/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3738;
import net.minecraft.class_7923;
import org.Netroaki.Main.HOReborn;

public final class GrowthTestManager {
    private GrowthTestManager() {
    }

    public static int start(class_2168 source) {
        class_3218 level = source.method_9225();
        class_2338 origin = class_2338.method_49638((class_2374)source.method_9222());
        ArrayList<class_2302> crops = new ArrayList<class_2302>();
        for (class_2248 block : class_7923.field_41175) {
            if (!(block instanceof class_2302)) continue;
            class_2302 crop = (class_2302)block;
            crops.add(crop);
        }
        if (crops.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"[HOR Debug] No crops found!"));
            return 0;
        }
        HOReborn.LOGGER.info("[HOR Debug] Found {} crop types to test", (Object)crops.size());
        int plotSize = 7;
        int spacing = 1;
        int stride = plotSize + spacing;
        int plotsPerRow = 8;
        long startTime = level.method_8510();
        ArrayList<PlotInfo> plots = new ArrayList<PlotInfo>();
        int cropTotal = 0;
        for (int i = 0; i < crops.size(); ++i) {
            class_2302 crop = (class_2302)crops.get(i);
            int plotRow = i / plotsPerRow;
            int plotCol = i % plotsPerRow;
            int baseX = origin.method_10263() + plotCol * stride;
            int baseZ = origin.method_10260() + plotRow * stride;
            for (int x = 0; x < plotSize; ++x) {
                for (int z = 0; z < plotSize; ++z) {
                    class_2338 farmPos = new class_2338(baseX + x, 200, baseZ + z);
                    level.method_8652(farmPos, class_2246.field_10362.method_9564(), 3);
                }
            }
            class_2338 waterPos = new class_2338(baseX + 3, 200, baseZ + 3);
            level.method_8652(waterPos, class_2246.field_10382.method_9564(), 3);
            int cropsInPlot = 0;
            for (int x = 0; x < plotSize; ++x) {
                for (int z = 0; z < plotSize; ++z) {
                    if (x == 3 && z == 3) continue;
                    class_2338 cropPos = new class_2338(baseX + x, 201, baseZ + z);
                    class_2680 cropState = crop.method_9828(0);
                    level.method_8652(cropPos, cropState, 3);
                    ++cropsInPlot;
                }
            }
            plots.add(new PlotInfo(baseX, baseZ));
            cropTotal += cropsInPlot;
        }
        int totalCrops = cropTotal;
        GrowthTestManager.schedulePoll(level, source, startTime, plots, totalCrops);
        source.method_9226(() -> class_2561.method_43470((String)("[HOR Debug] Growth test started with " + crops.size() + " crop types (" + totalCrops + " total crops).")), true);
        return 1;
    }

    private static void schedulePoll(class_3218 level, class_2168 source, long startGameTime, List<PlotInfo> plots, int totalCrops) {
        level.method_8503().execute(() -> GrowthTestManager.poll(level, source, startGameTime, plots, totalCrops));
    }

    private static void poll(class_3218 level, class_2168 source, long startGameTime, List<PlotInfo> plots, int totalCrops) {
        int matured = 0;
        int plotSize = 7;
        for (PlotInfo plot : plots) {
            for (int x = 0; x < plotSize; ++x) {
                for (int z = 0; z < plotSize; ++z) {
                    class_2302 crop;
                    class_2338 pos;
                    class_2680 state;
                    class_2248 class_22482;
                    if (x == 3 && z == 3 || !((class_22482 = (state = level.method_8320(pos = new class_2338(plot.baseX + x, 201, plot.baseZ + z))).method_26204()) instanceof class_2302) || !(crop = (class_2302)class_22482).method_9825(state)) continue;
                    ++matured;
                }
            }
        }
        if (matured >= totalCrops) {
            int maturedFinal = matured;
            int totalFinal = totalCrops;
            long ticksFinal = level.method_8510() - startGameTime;
            source.method_9226(() -> class_2561.method_43470((String)("[HOR Debug] Growth test complete: " + maturedFinal + "/" + totalFinal + " in " + ticksFinal + " ticks.")), true);
            return;
        }
        level.method_8503().method_18858((Runnable)new class_3738(level.method_8503().method_3780() + 10, () -> GrowthTestManager.poll(level, source, startGameTime, plots, totalCrops)));
    }

    private static class PlotInfo {
        final int baseX;
        final int baseZ;

        PlotInfo(int baseX, int baseZ) {
            this.baseX = baseX;
            this.baseZ = baseZ;
        }
    }
}

