/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.util;

import java.lang.reflect.Method;
import net.minecraft.class_1267;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_7924;
import org.Netroaki.Main.HOReborn;

public class SereneSeasonsAPI {
    private static boolean apiAvailable = false;
    private static Class<?> seasonHelperClass = null;
    private static Class<?> seasonClass = null;
    private static Class<?> iSeasonStateClass = null;
    private static Method getSeasonStateMethod = null;
    private static Method stateGetSeasonMethod = null;
    private static Method stateGetSubSeasonMethod = null;
    private static Object SPRING = null;
    private static Object SUMMER = null;
    private static Object AUTUMN = null;
    private static Object WINTER = null;

    private static void initializeAPI() {
        try {
            seasonHelperClass = Class.forName("sereneseasons.api.season.SeasonHelper");
            seasonClass = Class.forName("sereneseasons.api.season.Season");
            iSeasonStateClass = Class.forName("sereneseasons.api.season.ISeasonState");
            getSeasonStateMethod = seasonHelperClass.getMethod("getSeasonState", class_1937.class);
            stateGetSeasonMethod = iSeasonStateClass.getMethod("getSeason", new Class[0]);
            stateGetSubSeasonMethod = iSeasonStateClass.getMethod("getSubSeason", new Class[0]);
            SPRING = seasonClass.getField("SPRING").get(null);
            SUMMER = seasonClass.getField("SUMMER").get(null);
            AUTUMN = seasonClass.getField("AUTUMN").get(null);
            WINTER = seasonClass.getField("WINTER").get(null);
            apiAvailable = true;
            HOReborn.LOGGER.info("Serene Seasons API initialized successfully");
        }
        catch (Exception e) {
            apiAvailable = false;
            HOReborn.LOGGER.debug("Serene Seasons API not available: " + e.getMessage());
        }
    }

    public static boolean isAvailable() {
        return apiAvailable;
    }

    public static SeasonInfo getCurrentSeason(class_1937 level) {
        if (!apiAvailable) {
            return null;
        }
        try {
            Object seasonState = getSeasonStateMethod.invoke(null, level);
            if (seasonState == null) {
                return null;
            }
            Object season = stateGetSeasonMethod.invoke(seasonState, new Object[0]);
            Object subSeason = stateGetSubSeasonMethod.invoke(seasonState, new Object[0]);
            float strength = SereneSeasonsAPI.computeDerivedStrength(subSeason);
            return new SeasonInfo(season, subSeason, strength);
        }
        catch (Exception e) {
            HOReborn.LOGGER.warn("Failed to get season info: " + e.getMessage());
            return null;
        }
    }

    private static float computeDerivedStrength(Object subSeasonObj) {
        return 1.0f;
    }

    public static boolean isWinter(class_1937 level) {
        SeasonInfo info = SereneSeasonsAPI.getCurrentSeason(level);
        if (info == null) {
            return false;
        }
        return SereneSeasonsAPI.matchesBaseSeason(info, WINTER, "WINTER");
    }

    public static boolean isSummer(class_1937 level) {
        SeasonInfo info = SereneSeasonsAPI.getCurrentSeason(level);
        if (info == null) {
            return false;
        }
        return SereneSeasonsAPI.matchesBaseSeason(info, SUMMER, "SUMMER");
    }

    public static boolean isSpring(class_1937 level) {
        SeasonInfo info = SereneSeasonsAPI.getCurrentSeason(level);
        if (info == null) {
            return false;
        }
        return SereneSeasonsAPI.matchesBaseSeason(info, SPRING, "SPRING");
    }

    public static boolean isAutumn(class_1937 level) {
        SeasonInfo info = SereneSeasonsAPI.getCurrentSeason(level);
        if (info == null) {
            return false;
        }
        return SereneSeasonsAPI.matchesBaseSeason(info, AUTUMN, "AUTUMN");
    }

    public static String getSeasonName(class_1937 level) {
        String base;
        String name;
        SeasonInfo info = SereneSeasonsAPI.getCurrentSeason(level);
        if (info == null) {
            return "UNKNOWN";
        }
        if (info.subSeason != null && !(name = SereneSeasonsAPI.toDisplayName(String.valueOf(info.subSeason))).isEmpty()) {
            return name;
        }
        if (info.season != null && !(base = SereneSeasonsAPI.toDisplayName(String.valueOf(info.season))).isEmpty()) {
            return base;
        }
        return "UNKNOWN";
    }

    private static boolean matchesBaseSeason(SeasonInfo info, Object constant, String ... nameHints) {
        try {
            if (info.season != null && info.season.equals(constant)) {
                return true;
            }
            String sub = info.subSeason != null ? String.valueOf(info.subSeason) : "";
            String base = info.season != null ? String.valueOf(info.season) : "";
            for (String hint : nameHints) {
                if (sub.contains(hint)) {
                    return true;
                }
                if (!base.contains(hint)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static String toDisplayName(String enumName) {
        if (enumName == null || enumName.isEmpty()) {
            return "";
        }
        String name = enumName.toLowerCase().replace('_', ' ');
        String[] parts = name.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            sb.append(Character.toUpperCase(p.charAt(0))).append(p.substring(1)).append(' ');
        }
        return sb.toString().trim();
    }

    public static float getSeasonStrength(class_1937 level) {
        SeasonInfo info = SereneSeasonsAPI.getCurrentSeason(level);
        return info != null ? info.strength : 1.0f;
    }

    public static double calculateGrowthMultiplier(class_1937 level, double baseMultiplier) {
        if (!apiAvailable) {
            return baseMultiplier;
        }
        SeasonInfo info = SereneSeasonsAPI.getCurrentSeason(level);
        if (info == null) {
            return baseMultiplier;
        }
        double difficultyMultiplier = SereneSeasonsAPI.getDifficultyMultiplier(level);
        double adjusted = baseMultiplier * difficultyMultiplier;
        if (adjusted < 0.0) {
            adjusted = 0.0;
        }
        if (adjusted > 1.0) {
            adjusted = 1.0;
        }
        return adjusted;
    }

    public static boolean isCropFertile(class_1937 level, class_2338 pos, class_2680 state) {
        if (!apiAvailable) {
            return true;
        }
        try {
            Class<?> modFertilityClass = Class.forName("sereneseasons.init.ModFertility");
            Method isCropMethod = modFertilityClass.getMethod("isCrop", class_2680.class);
            Method isCropFertileMethod = modFertilityClass.getMethod("isCropFertile", String.class, class_1937.class, class_2338.class);
            boolean isCrop = (Boolean)isCropMethod.invoke(null, state);
            if (!isCrop) {
                return true;
            }
            String blockKey = level.method_30349().method_30530(class_7924.field_41254).method_10221((Object)state.method_26204()).toString();
            return (Boolean)isCropFertileMethod.invoke(null, blockKey, level, pos);
        }
        catch (Exception e) {
            HOReborn.LOGGER.warn("Failed to check crop fertility: " + e.getMessage());
            return true;
        }
    }

    public static boolean shouldCropsGrow(class_1937 level, class_2338 pos, class_2680 state) {
        if (!apiAvailable) {
            return true;
        }
        return SereneSeasonsAPI.isCropFertile(level, pos, state);
    }

    private static double getDifficultyMultiplier(class_1937 level) {
        try {
            class_1267 difficulty = level.method_8407();
            switch (difficulty) {
                case field_5801: {
                    return 1.0;
                }
                case field_5805: {
                    return 0.67;
                }
                case field_5802: {
                    return 0.5;
                }
                case field_5807: {
                    return 0.34;
                }
            }
            return 0.5;
        }
        catch (Exception e) {
            HOReborn.LOGGER.error("Error getting difficulty multiplier", (Throwable)e);
            return 0.5;
        }
    }

    static {
        SereneSeasonsAPI.initializeAPI();
    }

    public static class SeasonInfo {
        public final Object season;
        public final Object subSeason;
        public final float strength;

        public SeasonInfo(Object season, Object subSeason, float strength) {
            this.season = season;
            this.subSeason = subSeason;
            this.strength = strength;
        }

        public String toString() {
            return "SeasonInfo{season=" + String.valueOf(this.season) + ", subSeason=" + String.valueOf(this.subSeason) + ", strength=" + this.strength + "}";
        }
    }
}

