/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.forge;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.EventResult;
import dev.architectury.platform.forge.EventBuses;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.Netroaki.Main.HOReborn;
import org.Netroaki.Main.config.HungerOverhaulConfig;
import org.Netroaki.Main.handlers.FoodEventHandler;
import org.Netroaki.Main.modules.CropModule;
import org.Netroaki.Main.modules.FoodModule;
import org.Netroaki.Main.modules.ToolModule;

@Mod(value="hunger_overhaul_reborn")
public final class HORebornForge {
    public HORebornForge() {
        EventBuses.registerModEventBus((String)"hunger_overhaul_reborn", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        HOReborn.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder cmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ho_hunger").requires(src -> src.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            int value = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            player.m_36324_().m_38705_(value);
            player.m_36324_().m_38717_(0.0f);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Set hunger to " + value)), true);
            return 1;
        })).then(Commands.m_82129_((String)"saturation", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)20.0f)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            int value = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            float sat = FloatArgumentType.getFloat((CommandContext)ctx, (String)"saturation");
            player.m_36324_().m_38705_(value);
            player.m_36324_().m_38717_(sat);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Set hunger to " + value + " and saturation to " + sat)), true);
            return 1;
        })));
        event.getDispatcher().register(cmd);
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        Component tooltip;
        if (HungerOverhaulConfig.getInstance().food.showFoodTooltips && (tooltip = FoodModule.getFoodTooltip(event.getItemStack())) != null) {
            event.getToolTip().add(tooltip);
        }
    }

    @SubscribeEvent
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            FoodEventHandler.onFoodConsumed(player, event.getItem());
        }
    }

    @SubscribeEvent
    public void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        FoodProperties food;
        ItemStack stack = event.getItem();
        if (stack.m_41614_() && HungerOverhaulConfig.getInstance().food.modifyEatingSpeed && (food = stack.m_41720_().m_41473_()) != null) {
            int foodValue = food.m_38744_();
            int duration = FoodEventHandler.getEatingDuration(foodValue);
            event.setDuration(duration);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getState().m_60734_() instanceof TallGrassBlock) {
            event.setCanceled(true);
            LevelAccessor level = event.getLevel();
            BlockPos pos = event.getPos();
            level.m_7471_(pos, false);
            return;
        }
        Block pos = event.getState().m_60734_();
        if (pos instanceof CropBlock) {
            CropBlock crop = (CropBlock)pos;
            if (!event.getLevel().m_5776_()) {
                ServerLevel server = (ServerLevel)event.getLevel();
                BlockPos pos2 = event.getPos();
                ItemStack seed = crop.m_7397_((BlockGetter)server, pos2, event.getState());
                event.setCanceled(true);
                server.m_7471_(pos2, false);
                if (!seed.m_41619_()) {
                    Block.m_49840_((Level)server, (BlockPos)pos2, (ItemStack)new ItemStack((ItemLike)seed.m_41720_(), 1));
                }
            }
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        MobEffectInstance inst;
        MobEffect effect = (MobEffect)HOReborn.HUNGRY_EFFECT.get();
        if (event.getEntity() != null && event.getEntity().m_21023_(effect) && (inst = event.getEntity().m_21124_(effect)) != null && inst.m_19564_() >= 2) {
            event.setNewSpeed(event.getNewSpeed() * 0.5f);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        CropBlock crop;
        BlockPos pos = event.getPos();
        BlockState state = event.getLevel().m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof CropBlock && (crop = (CropBlock)block).m_52307_(state)) {
            if (!event.getLevel().m_5776_() && event.getEntity() != null) {
                ServerLevel server = (ServerLevel)event.getLevel();
                for (ItemStack drop : Block.m_49874_((BlockState)state, (ServerLevel)server, (BlockPos)pos, null, (Entity)event.getEntity(), (ItemStack)event.getItemStack())) {
                    Block.m_49840_((Level)server, (BlockPos)pos, (ItemStack)drop);
                }
                server.m_7731_(pos, crop.m_52289_(0), 3);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        ToolModule toolModule = new ToolModule();
        EventResult result = toolModule.onHoeUse(event.getEntity(), event.getHand(), event.getPos(), event.getHitVec());
        if (result != EventResult.pass()) {
            event.setCanceled(true);
            return;
        }
        CropModule cropModule = new CropModule();
        result = cropModule.onBoneMealUse(event.getEntity(), event.getHand(), event.getPos(), event.getHitVec());
        if (result != EventResult.pass()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AgeableMob) {
            AgeableMob mob = (AgeableMob)livingEntity;
            double childMul = HungerOverhaulConfig.getInstance().animals.childDurationMultiplier;
            if (childMul > 1.0 && mob.m_6162_() && !mob.m_9236_().m_5776_()) {
                mob.m_146762_(mob.m_146764_() - (int)((childMul - 1.0) * 1.0));
            }
        }
    }

    @SubscribeEvent
    public void onVillagerTrades(VillagerTradesEvent event) {
        ResourceLocation id;
        if (!HungerOverhaulConfig.getInstance().integration.enableHarvestCraftIntegration) {
            return;
        }
        if (event.getType() == VillagerProfession.f_35590_) {
            ((List)event.getTrades().get(1)).add(new BasicItemListing(new ItemStack((ItemLike)Items.f_42616_), ItemStack.f_41583_, Items.f_42616_.m_7968_(), 0, 0, 0.0f));
            for (Item item : BuiltInRegistries.f_257033_) {
                id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
                if (id == null || !id.m_135827_().equals("harvestcraft") || item.m_41473_() == null) continue;
                ((List)event.getTrades().get(1)).add(new BasicItemListing(new ItemStack((ItemLike)item, 8), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42616_, 1), 16, 2, 0.05f));
            }
        }
        if (event.getType() == VillagerProfession.f_35587_) {
            for (Item item : BuiltInRegistries.f_257033_) {
                int nutrition;
                id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
                if (id == null || !id.m_135827_().equals("harvestcraft") || item.m_41473_() == null || (nutrition = item.m_41473_().m_38744_()) < 8) continue;
                ((List)event.getTrades().get(3)).add(new BasicItemListing(new ItemStack((ItemLike)Items.f_42616_, 3), ItemStack.f_41583_, new ItemStack((ItemLike)item, 1), 12, 5, 0.05f));
            }
        }
    }

    @SubscribeEvent
    public void onBabySpawn(BabyEntitySpawnEvent event) {
        double breedMul = HungerOverhaulConfig.getInstance().animals.breedingTimeoutMultiplier;
        if (breedMul > 1.0 && event.getParentA() != null && event.getParentB() != null) {
            int base = 6000;
            int newCd = (int)Math.round((double)base * breedMul);
            if (event.getParentA() instanceof AgeableMob) {
                ((AgeableMob)event.getParentA()).m_146762_(newCd);
            }
            if (event.getParentB() instanceof AgeableMob) {
                ((AgeableMob)event.getParentB()).m_146762_(newCd);
            }
        }
        if (event.getChild() instanceof AgeableMob) {
            double childMul = HungerOverhaulConfig.getInstance().animals.childDurationMultiplier;
            int baseBaby = -24000;
            event.getChild().m_146762_((int)Math.round((double)baseBaby * childMul));
        }
    }
}

