/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.handlers;

import com.mojang.datafixers.util.Pair;
import dev.architectury.event.events.common.LifecycleEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.Netroaki.Main.HOReborn;
import org.Netroaki.Main.config.HungerOverhaulConfig;
import org.Netroaki.Main.util.FoodCategorizer;
import org.Netroaki.Main.util.FoodUtil;

public class FoodEventHandler {
    private static final Map<Item, FoodProperties> ORIGINAL_FOOD_PROPERTIES = new HashMap<Item, FoodProperties>();
    private static final Map<Item, Integer> ORIGINAL_MAX_STACK_SIZES = new HashMap<Item, Integer>();

    public static void register() {
        LifecycleEvent.SERVER_LEVEL_LOAD.register(FoodEventHandler::onServerStarting);
    }

    private static void onServerStarting(Level level) {
        if (HungerOverhaulConfig.getInstance().food.modifyFoodStats) {
            FoodEventHandler.modifyFoodProperties();
        }
    }

    public static void onFoodConsumed(Player player, ItemStack stack) {
        int foodValue;
        int duration;
        FoodProperties food;
        if (HungerOverhaulConfig.getInstance().food.enableWellFedEffect && stack.m_41614_() && (food = stack.m_41720_().m_41473_()) != null && (duration = FoodEventHandler.getWellFedDuration(foodValue = food.m_38744_())) > 0) {
            MobEffectInstance existingEffect = player.m_21124_((MobEffect)HOReborn.WELL_FED_EFFECT.get());
            int newDuration = existingEffect != null ? existingEffect.m_19557_() + duration : duration;
            int newAmplifier = Math.min(existingEffect != null ? existingEffect.m_19564_() + 1 : 0, 3);
            player.m_7292_(new MobEffectInstance((MobEffect)HOReborn.WELL_FED_EFFECT.get(), newDuration, newAmplifier));
        }
    }

    public static void onItemUse(Player player, ItemStack stack) {
        FoodProperties food;
        if (HungerOverhaulConfig.getInstance().food.modifyEatingSpeed && stack.m_41614_() && (food = stack.m_41720_().m_41473_()) != null) {
            int foodValue = food.m_38744_();
            int n = FoodEventHandler.getEatingDuration(foodValue);
        }
    }

    private static void modifyFoodProperties() {
        for (Item item : FoodUtil.getAllFoodItems()) {
            if (item.m_41473_() == null) continue;
            ORIGINAL_FOOD_PROPERTIES.put(item, item.m_41473_());
            ORIGINAL_MAX_STACK_SIZES.put(item, item.m_41459_());
        }
        if (HungerOverhaulConfig.getInstance().food.modifyFoodValues) {
            for (Item item : FoodUtil.getAllFoodItems()) {
                FoodProperties original = ORIGINAL_FOOD_PROPERTIES.get(item);
                if (original == null) continue;
                FoodProperties modified = FoodEventHandler.createModifiedFoodProperties(item, original);
                FoodUtil.setFoodProperties(item, modified);
            }
        }
        if (HungerOverhaulConfig.getInstance().food.modifyStackSizes) {
            for (Item item : FoodUtil.getAllFoodItems()) {
                FoodProperties food = item.m_41473_();
                if (food == null) continue;
                int newStackSize = FoodEventHandler.getStackSizeForFoodValue(food.m_38744_());
                FoodUtil.setMaxStackSize(item, newStackSize);
            }
        }
    }

    private static FoodProperties createModifiedFoodProperties(Item item, FoodProperties original) {
        int wfDuration;
        float saturation = original.m_38745_();
        int nutrition = FoodCategorizer.categorizeFood(item, original);
        if (FoodCategorizer.isModFood(item)) {
            nutrition = (int)Math.max(1.0, Math.floor((double)nutrition / HungerOverhaulConfig.getInstance().food.modFoodValueDivider));
            saturation /= (float)HungerOverhaulConfig.getInstance().food.modFoodValueDivider;
        }
        FoodProperties.Builder builder = new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturation);
        if (original.m_38746_()) {
            builder.m_38757_();
        }
        if (original.m_38747_()) {
            builder.m_38765_();
        }
        if (original.m_38748_()) {
            builder.m_38766_();
        }
        for (Pair pair : original.m_38749_()) {
            MobEffectInstance inst = (MobEffectInstance)pair.getFirst();
            float chance = ((Float)pair.getSecond()).floatValue();
            if (inst == null || !(chance > 0.0f)) continue;
            MobEffectInstance copy = new MobEffectInstance(inst);
            builder.m_38762_(copy, chance);
        }
        if (HungerOverhaulConfig.getInstance().food.enableWellFedEffect && (wfDuration = FoodEventHandler.getWellFedDuration(nutrition)) > 0) {
            builder.m_38762_(new MobEffectInstance((MobEffect)HOReborn.WELL_FED_EFFECT.get(), wfDuration, 0), 1.0f);
        }
        return builder.m_38767_();
    }

    private static int getWellFedDuration(int foodValue) {
        if (foodValue >= 14) {
            return 480;
        }
        if (foodValue >= 10) {
            return 240;
        }
        if (foodValue >= 7) {
            return 120;
        }
        if (foodValue >= 4) {
            return 40;
        }
        return 0;
    }

    public static int getEatingDuration(int foodValue) {
        if (foodValue >= 14) {
            return 64;
        }
        if (foodValue >= 10) {
            return 48;
        }
        if (foodValue >= 7) {
            return 32;
        }
        if (foodValue >= 4) {
            return 24;
        }
        return 16;
    }

    private static int getStackSizeForFoodValue(int foodValue) {
        if (foodValue >= 14) {
            return 1;
        }
        if (foodValue >= 10) {
            return 4;
        }
        if (foodValue >= 7) {
            return 8;
        }
        if (foodValue >= 4) {
            return 16;
        }
        return 32;
    }

    public static String getFoodDescription(int foodValue, float saturation) {
        return FoodCategorizer.getFoodCategoryDescription(foodValue);
    }
}

