/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.handlers;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.Level;
import org.Netroaki.Main.HOReborn;
import org.Netroaki.Main.config.HungerOverhaulConfig;

public class PlayerEventHandler {
    private static final int BASE_HUNGER_TICK_RATE = 24000;
    private static int hungerTickCounter = 0;
    private static final Map<UUID, Integer> wellFedRegenTicksRemaining = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> lastWellFedAmplifier = new HashMap<UUID, Integer>();

    public static void register() {
        TickEvent.PLAYER_PRE.register(PlayerEventHandler::onPlayerTick);
        PlayerEvent.PLAYER_RESPAWN.register(PlayerEventHandler::onPlayerRespawn);
        PlayerEvent.PLAYER_JOIN.register(PlayerEventHandler::onPlayerJoin);
    }

    private static void onPlayerTick(Player player) {
        int baseHealInterval;
        int healInterval;
        long gameTime;
        int threshold;
        int interval;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        HungerOverhaulConfig config = HungerOverhaulConfig.getInstance();
        Level level = player.m_9236_();
        double hungerSpeed = 1.0;
        double healSpeed = 1.0;
        switch (level.m_46791_()) {
            case PEACEFUL: 
            case EASY: {
                hungerSpeed = 0.75;
                healSpeed = 0.75;
                break;
            }
            case NORMAL: {
                hungerSpeed = 1.0;
                healSpeed = 1.0;
                break;
            }
            case HARD: {
                hungerSpeed = 1.5;
                healSpeed = 1.5;
            }
        }
        if (config.hunger.harvestCraftHungerLossIncrease && Platform.isModLoaded((String)"harvestcraft")) {
            hungerSpeed *= config.hunger.harvestCraftHungerLossMultiplier;
        }
        if (config.hunger.constantHungerLoss && ++hungerTickCounter >= (interval = (int)Math.max(1L, Math.round(24000.0 / hungerSpeed)))) {
            hungerTickCounter = 0;
            FoodData foodData = player.m_36324_();
            if (foodData.m_38702_() > 0) {
                foodData.m_38705_(foodData.m_38702_() - 1);
            }
        }
        FoodData foodData = player.m_36324_();
        int foodLevel = foodData.m_38702_();
        if (config.hunger.lowHungerEffects) {
            int desiredAmplifier = -1;
            if (foodLevel <= 2) {
                desiredAmplifier = 2;
            } else if (foodLevel <= 4) {
                desiredAmplifier = 1;
            } else if (foodLevel <= 6) {
                desiredAmplifier = 0;
            }
            if (desiredAmplifier >= 0) {
                MobEffectInstance current = player.m_21124_((MobEffect)HOReborn.HUNGRY_EFFECT.get());
                if (current == null || current.m_19564_() != desiredAmplifier) {
                    player.m_21195_((MobEffect)HOReborn.HUNGRY_EFFECT.get());
                    player.m_7292_(new MobEffectInstance((MobEffect)HOReborn.HUNGRY_EFFECT.get(), Integer.MAX_VALUE, desiredAmplifier, false, true, true));
                }
            } else {
                player.m_21195_((MobEffect)HOReborn.HUNGRY_EFFECT.get());
            }
        }
        if (config.health.healthHealsAboveThreeShanks && player.m_21223_() < player.m_21233_() && foodLevel >= (threshold = Math.max(0, config.health.healthHealingThreshold)) && (gameTime = level.m_46467_()) % (long)(healInterval = (int)Math.max(1L, Math.round((double)(baseHealInterval = 120) / healSpeed))) == 0L) {
            player.m_5634_(1.0f);
        }
        MobEffect wellFed = (MobEffect)HOReborn.WELL_FED_EFFECT.get();
        MobEffectInstance wf = player.m_21124_(wellFed);
        UUID id = player.m_20148_();
        if (wf != null) {
            Integer ticks;
            int amp = wf.m_19564_();
            Integer lastAmp = lastWellFedAmplifier.get(id);
            if (lastAmp == null || lastAmp != amp) {
                wellFedRegenTicksRemaining.put(id, 20);
                lastWellFedAmplifier.put(id, amp);
            }
            if ((ticks = wellFedRegenTicksRemaining.get(id)) != null && ticks > 0) {
                if (ticks % 10 == 0 && player.m_21223_() < player.m_21233_()) {
                    player.m_5634_(1.0f);
                }
                wellFedRegenTicksRemaining.put(id, ticks - 1);
            }
        } else {
            lastWellFedAmplifier.remove(id);
            wellFedRegenTicksRemaining.remove(id);
        }
        if (foodLevel <= 0 && config.hunger.instantDeathOnZeroHunger) {
            player.m_6469_(player.m_269291_().m_269064_(), Float.MAX_VALUE);
        }
    }

    private static void onPlayerRespawn(ServerPlayer player, boolean conqueredEnd) {
        HungerOverhaulConfig config = HungerOverhaulConfig.getInstance();
        if (config.hunger.modifyRespawnHunger) {
            int respawnHunger = PlayerEventHandler.getRespawnHungerValue(player.m_9236_().m_46791_());
            player.m_36324_().m_38705_(respawnHunger);
        }
    }

    private static void onPlayerJoin(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerEventHandler.onPlayerRespawn(serverPlayer, false);
        }
    }

    private static int getRespawnHungerValue(Difficulty difficulty) {
        HungerOverhaulConfig config = HungerOverhaulConfig.getInstance();
        int baseHunger = config.hunger.respawnHungerValue;
        int modifier = config.hunger.respawnHungerDifficultyModifier;
        switch (difficulty) {
            case PEACEFUL: 
            case EASY: {
                return baseHunger;
            }
            case NORMAL: {
                return baseHunger - modifier;
            }
            case HARD: {
                return baseHunger - modifier * 2;
            }
        }
        return baseHunger;
    }
}

