/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.mixin;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BowlFoodItem.class})
public class BowlFoodItemMixin {
    private static final ThreadLocal<ItemStack> ORIGINAL_STACK = new ThreadLocal();
    private static final ThreadLocal<Integer> ORIGINAL_COUNT = new ThreadLocal();

    @Inject(method={"finishUsingItem"}, at={@At(value="HEAD")})
    private void captureOriginal(ItemStack stack, Level level, LivingEntity entity, CallbackInfoReturnable<ItemStack> cir) {
        ORIGINAL_STACK.set(stack.m_41777_());
        ORIGINAL_COUNT.set(stack.m_41613_());
    }

    @Inject(method={"finishUsingItem"}, at={@At(value="RETURN")}, cancellable=true)
    private void onFinishUsingItem(ItemStack stack, Level level, LivingEntity entity, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack original = ORIGINAL_STACK.get();
        Integer origCount = ORIGINAL_COUNT.get();
        ORIGINAL_STACK.remove();
        ORIGINAL_COUNT.remove();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (level.f_46443_) {
            return;
        }
        if (player.m_150110_().f_35937_) {
            return;
        }
        if (original == null || origCount == null) {
            return;
        }
        ItemStack returned = (ItemStack)cir.getReturnValue();
        if (origCount > 1) {
            ItemStack newStack = original.m_41777_();
            newStack.m_41774_(1);
            ItemStack bowl = new ItemStack((ItemLike)Items.f_42399_);
            if (!player.m_150109_().m_36054_(bowl)) {
                player.m_36176_(bowl, false);
            }
            cir.setReturnValue((Object)newStack);
        } else if (returned.m_41720_() != Items.f_42399_) {
            cir.setReturnValue((Object)new ItemStack((ItemLike)Items.f_42399_));
        }
    }
}

