/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.mixin;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.Netroaki.Main.config.HungerOverhaulConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HoeItem.class})
public class HoeItemMixin {
    private static final Random RANDOM = new Random();

    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUseOn(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        boolean waterNearby;
        BlockPos pos;
        if (!HungerOverhaulConfig.getInstance().tools.modifyHoeUse) {
            return;
        }
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        if (state.m_60713_(Blocks.f_50440_) && !(waterNearby = this.isWaterNearby(level, pos))) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 3);
            double seedChance = this.getSeedChanceForDifficulty(level);
            if (RANDOM.nextDouble() < seedChance) {
                ItemStack seedStack = this.getRandomSeed();
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)seedStack);
            }
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)level.m_5776_()));
        }
    }

    private boolean isWaterNearby(Level level, BlockPos pos) {
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                for (int y = -2; y <= 2; ++y) {
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    if (!level.m_8055_(checkPos).m_60713_(Blocks.f_49990_)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private double getSeedChanceForDifficulty(Level level) {
        double baseChance = HungerOverhaulConfig.getInstance().tools.seedChanceBase;
        double multiplier = HungerOverhaulConfig.getInstance().tools.seedChanceMultiplier;
        switch (level.m_46791_()) {
            case PEACEFUL: {
                return baseChance * multiplier * 0.4;
            }
            case EASY: {
                return baseChance * multiplier * 0.3;
            }
            case NORMAL: {
                return baseChance * multiplier * 0.2;
            }
            case HARD: {
                return baseChance * multiplier * 0.1;
            }
        }
        return baseChance * multiplier * 0.2;
    }

    private ItemStack getRandomSeed() {
        ItemStack[] seeds = new ItemStack[]{new ItemStack((ItemLike)Items.f_42404_), new ItemStack((ItemLike)Items.f_42733_), new ItemStack((ItemLike)Items.f_42577_), new ItemStack((ItemLike)Items.f_42578_)};
        return seeds[RANDOM.nextInt(seeds.length)];
    }
}

