/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.modules;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.Netroaki.Main.HOReborn;
import org.Netroaki.Main.config.HungerOverhaulConfig;
import org.Netroaki.Main.util.FoodUtil;

public class FoodModule {
    public void init() {
        HOReborn.LOGGER.info("Initializing Food Module");
        if (HungerOverhaulConfig.getInstance().food.showFoodTooltips) {
            this.registerTooltipEvents();
        }
        if (HungerOverhaulConfig.getInstance().food.enableLowHungerWarnings) {
            this.registerGUIEvents();
        }
    }

    private void registerTooltipEvents() {
        HOReborn.LOGGER.info("Food tooltips enabled");
    }

    private void registerGUIEvents() {
        HOReborn.LOGGER.info("Low hunger/health warnings enabled");
    }

    public static Component getFoodTooltip(ItemStack stack) {
        if (!stack.m_41614_()) {
            return null;
        }
        String description = FoodUtil.getFoodDescription(stack);
        if (description.isEmpty()) {
            return null;
        }
        return Component.m_237113_((String)description);
    }

    public static void renderLowHungerWarning(GuiGraphics graphics, int screenWidth, int screenHeight) {
        int y;
        int x;
        int color;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        HungerOverhaulConfig config = HungerOverhaulConfig.getInstance();
        if (!config.food.enableLowHungerWarnings) {
            return;
        }
        int hungerLevel = minecraft.f_91074_.m_36324_().m_38702_();
        float health = minecraft.f_91074_.m_21223_();
        float maxHealth = minecraft.f_91074_.m_21233_();
        Font font = minecraft.f_91062_;
        if (hungerLevel <= 6) {
            String hungerText = "Low Hunger!";
            color = hungerLevel <= 2 ? 0xFF0000 : (hungerLevel <= 4 ? 0xFFAA00 : 0xFFFF00);
            x = screenWidth - font.m_92895_(hungerText) - 10;
            y = 10;
            graphics.m_280488_(font, hungerText, x, y, color);
        }
        if (health <= maxHealth * 0.3f) {
            String healthText = "Low Health!";
            color = 0xFF0000;
            x = 10;
            y = 10;
            graphics.m_280488_(font, healthText, x, y, color);
        }
    }
}

