/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.Netroaki.Main.util.FoodUtil;

public class FoodCategorizer {
    private static final Map<Item, FoodCategory> SPECIFIC_CATEGORIES = new HashMap<Item, FoodCategory>();

    public static int categorizeFood(Item item, FoodProperties originalProperties) {
        FoodCategory specificCategory = SPECIFIC_CATEGORIES.get(item);
        if (specificCategory != null) {
            return specificCategory.getNutritionValue();
        }
        int originalNutrition = originalProperties.m_38744_();
        if (originalNutrition <= 2) {
            return FoodCategory.RAW_FOOD.getNutritionValue();
        }
        if (originalNutrition <= 4) {
            return FoodCategory.COOKED_FOOD.getNutritionValue();
        }
        if (originalNutrition <= 6) {
            return FoodCategory.LIGHT_MEAL.getNutritionValue();
        }
        if (originalNutrition <= 8) {
            return FoodCategory.AVERAGE_MEAL.getNutritionValue();
        }
        if (originalNutrition <= 12) {
            return FoodCategory.LARGE_MEAL.getNutritionValue();
        }
        return FoodCategory.FEAST.getNutritionValue();
    }

    public static String getFoodCategoryDescription(int nutritionValue) {
        if (nutritionValue >= 10) {
            return "Feast";
        }
        if (nutritionValue >= 8) {
            return "Large Meal";
        }
        if (nutritionValue >= 6) {
            return "Nourishing Meal";
        }
        if (nutritionValue >= 4) {
            return "Light Meal";
        }
        if (nutritionValue >= 2) {
            return "Cooked Food";
        }
        return "Raw Food";
    }

    public static boolean isModFood(Item item) {
        return FoodUtil.isModFood(item);
    }

    static {
        SPECIFIC_CATEGORIES.put(Items.f_42405_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42619_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42620_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42732_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42410_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42780_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_151079_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42730_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42575_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42046_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42579_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42485_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42581_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42658_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42697_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42526_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42527_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42528_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42583_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42591_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42675_, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42580_, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42486_, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42582_, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42659_, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42698_, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42530_, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42531_, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42674_, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(Items.f_42406_, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(Items.f_42572_, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(Items.f_42502_, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(Items.f_42687_, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(Items.f_42436_, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(Items.f_42437_, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(Items.f_42576_, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(Items.f_42787_, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(Items.f_42400_, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(Items.f_42734_, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(Items.f_42699_, FoodCategory.AVERAGE_MEAL);
        SPECIFIC_CATEGORIES.put(Items.f_42718_, FoodCategory.AVERAGE_MEAL);
    }

    public static enum FoodCategory {
        RAW_FOOD(1),
        COOKED_FOOD(2),
        LIGHT_MEAL(4),
        AVERAGE_MEAL(6),
        LARGE_MEAL(8),
        FEAST(10);

        private final int nutritionValue;

        private FoodCategory(int nutritionValue) {
            this.nutritionValue = nutritionValue;
        }

        public int getNutritionValue() {
            return this.nutritionValue;
        }
    }
}

