/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FoodUtil {
    public static List<Item> getAllFoodItems() {
        ArrayList<Item> foodItems = new ArrayList<Item>();
        for (Item item : BuiltInRegistries.f_257033_) {
            if (item.m_41473_() == null) continue;
            foodItems.add(item);
        }
        return foodItems;
    }

    public static boolean isModFood(FoodProperties food) {
        return false;
    }

    public static boolean isModFood(Item item) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        if (id == null) {
            return false;
        }
        String namespace = id.m_135827_();
        return !namespace.equals("minecraft");
    }

    public static void setFoodProperties(Item item, FoodProperties properties) {
        try {
            String[] possibleFieldNames;
            Field foodPropertiesField = null;
            for (String fieldName : possibleFieldNames = new String[]{"foodProperties", "food", "foodData"}) {
                try {
                    foodPropertiesField = Item.class.getDeclaredField(fieldName);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            if (foodPropertiesField != null) {
                foodPropertiesField.setAccessible(true);
                foodPropertiesField.set(item, properties);
            } else {
                System.err.println("Could not find food properties field for " + String.valueOf(item));
            }
        }
        catch (Exception e) {
            System.err.println("Failed to set food properties for " + String.valueOf(item) + ": " + e.getMessage());
        }
    }

    public static void setMaxStackSize(Item item, int maxStackSize) {
        try {
            String[] possibleFieldNames;
            Field maxStackSizeField = null;
            for (String fieldName : possibleFieldNames = new String[]{"maxStackSize", "maxCount", "maxStack"}) {
                try {
                    maxStackSizeField = Item.class.getDeclaredField(fieldName);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            if (maxStackSizeField != null) {
                maxStackSizeField.setAccessible(true);
                maxStackSizeField.set(item, maxStackSize);
            } else {
                System.err.println("Could not find max stack size field for " + String.valueOf(item));
            }
        }
        catch (Exception e) {
            System.err.println("Failed to set max stack size for " + String.valueOf(item) + ": " + e.getMessage());
        }
    }

    public static String getFoodDescription(ItemStack stack) {
        FoodProperties food = stack.m_41720_().m_41473_();
        if (food == null) {
            return "";
        }
        int nutrition = food.m_38744_();
        float saturation = food.m_38745_();
        return FoodUtil.getFoodDescription(nutrition, saturation);
    }

    public static String getFoodDescription(int nutrition, float saturation) {
        if (nutrition >= 14) {
            return "Feast";
        }
        if (nutrition >= 10) {
            return "Large Meal";
        }
        if (nutrition >= 7) {
            return "Nourishing Meal";
        }
        if (nutrition >= 4) {
            return "Light Meal";
        }
        if (nutrition >= 2) {
            return "Snack";
        }
        return "Morsel";
    }

    public static int getWellFedDuration(int foodValue) {
        if (foodValue >= 14) {
            return 480;
        }
        if (foodValue >= 10) {
            return 240;
        }
        if (foodValue >= 7) {
            return 120;
        }
        if (foodValue >= 4) {
            return 40;
        }
        return 0;
    }

    public static int getEatingDuration(int foodValue) {
        if (foodValue >= 14) {
            return 64;
        }
        if (foodValue >= 10) {
            return 48;
        }
        if (foodValue >= 7) {
            return 32;
        }
        if (foodValue >= 4) {
            return 24;
        }
        return 16;
    }

    public static int getStackSizeForFoodValue(int foodValue) {
        if (foodValue >= 14) {
            return 1;
        }
        if (foodValue >= 10) {
            return 4;
        }
        if (foodValue >= 7) {
            return 8;
        }
        if (foodValue >= 4) {
            return 16;
        }
        return 32;
    }

    public static boolean isHarvestCraftFood(Item item) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        return id != null && id.m_135827_().equals("harvestcraft");
    }
}

