/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.unstriplog.item;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BarkItem
extends Item {
    private static final Map<Block, Block> REVERSE_STRIPPED = new HashMap<Block, Block>();

    private static void buildReverseStrippedMap() {
        for (Block block : BuiltInRegistries.BLOCK) {
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            String path = id.getPath();
            if (!path.startsWith("stripped_") || !path.endsWith("_log") && !path.endsWith("_wood") && !path.endsWith("stem") && !path.endsWith("hyphae") || path.length() <= "stripped_".length()) continue;
            String originalPath = path.substring("stripped_".length());
            ResourceLocation originalId = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)originalPath);
            Block original = (Block)BuiltInRegistries.BLOCK.getValue(originalId);
            if (original == Blocks.AIR) continue;
            REVERSE_STRIPPED.put(block, original);
        }
    }

    public BarkItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState targetState = level.getBlockState(pos = context.getClickedPos());
        Block reversed = REVERSE_STRIPPED.get(targetState.getBlock());
        if (reversed != null) {
            if (!level.isClientSide) {
                BlockState newState = reversed.defaultBlockState();
                if (newState.hasProperty((Property)RotatedPillarBlock.AXIS) && targetState.hasProperty((Property)RotatedPillarBlock.AXIS)) {
                    Direction.Axis axis = (Direction.Axis)targetState.getValue((Property)RotatedPillarBlock.AXIS);
                    newState = (BlockState)newState.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis);
                }
                level.setBlock(pos, newState, 3);
                level.playSound(null, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                context.getItemInHand().shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType, FuelValues fuelValues) {
        return 150;
    }

    static {
        BarkItem.buildReverseStrippedMap();
    }
}

