/*
 * Decompiled with CFR 0.152.
 */
package nores.copperflare.fluid;

import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import nores.copperflare.init.CopperflareModBlocks;
import nores.copperflare.init.CopperflareModFluidTypes;
import nores.copperflare.init.CopperflareModFluids;
import nores.copperflare.init.CopperflareModItems;

public abstract class InkBucketFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)CopperflareModFluidTypes.INK_BUCKET_TYPE.get(), () -> (Fluid)CopperflareModFluids.INK_BUCKET.get(), () -> (Fluid)CopperflareModFluids.FLOWING_INK_BUCKET.get()).explosionResistance(100.0f).tickRate(3).bucket(() -> (Item)CopperflareModItems.INK_BUCKET_BUCKET.get()).block(() -> (LiquidBlock)CopperflareModBlocks.INK_BUCKET.get());

    private InkBucketFluid() {
        super(PROPERTIES);
    }

    public static class Flowing
    extends InkBucketFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends InkBucketFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

