/*
 * Decompiled with CFR 0.152.
 */
package nores.copperflare.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import nores.copperflare.potion.CombustionMobEffect;
import nores.copperflare.potion.IsEntityOnInkMobEffect;
import nores.copperflare.potion.SniperZoomMobEffect;
import nores.copperflare.potion.SplashMobEffect;
import nores.copperflare.procedures.SniperZoomEffectExpiresProcedure;

@EventBusSubscriber
public class CopperflareModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"copperflare");
    public static final DeferredHolder<MobEffect, MobEffect> SNIPER_ZOOM = REGISTRY.register("sniper_zoom", () -> new SniperZoomMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> COMBUSTION = REGISTRY.register("combustion", () -> new CombustionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SPLASH = REGISTRY.register("splash", () -> new SplashMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> IS_ENTITY_ON_INK = REGISTRY.register("is_entity_on_ink", () -> new IsEntityOnInkMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            CopperflareModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            CopperflareModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(SNIPER_ZOOM)) {
            SniperZoomEffectExpiresProcedure.execute(entity);
        }
    }
}

