/*
 * Decompiled with CFR 0.152.
 */
package nores.copperflare.procedures;

import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import nores.copperflare.init.CopperflareModItems;

public class FireballShooterShootProcedureProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        Player _playerHasItem;
        if (entity == null) {
            return;
        }
        if (entity instanceof Player && (_playerHasItem = (Player)entity).getInventory().contains(new ItemStack((ItemLike)CopperflareModItems.FIREBALL.get()))) {
            Level _level;
            ServerPlayer _player;
            Player player;
            Entity _shootFrom = entity;
            Level projectileLevel = _shootFrom.level();
            if (!projectileLevel.isClientSide()) {
                LargeFireball _entityToSpawn = new LargeFireball(EntityType.FIREBALL, projectileLevel);
                _entityToSpawn.setPos(_shootFrom.getX(), _shootFrom.getEyeY() - 0.1, _shootFrom.getZ());
                _entityToSpawn.shoot(_shootFrom.getLookAngle().x, _shootFrom.getLookAngle().y, _shootFrom.getLookAngle().z, 1.0f, 0.0f);
                projectileLevel.addFreshEntity((Entity)_entityToSpawn);
            }
            if (entity instanceof Player && (player = (Player)entity).level().isClientSide()) {
                float originalPitch = player.getXRot();
                player.setXRot(originalPitch - 10.0f);
                player.getPersistentData().putFloat("recoil_return_pitch", originalPitch);
                player.getPersistentData().putInt("recoil_timer", 3);
            }
            if (entity instanceof ServerPlayer) {
                AdvancementProgress _ap;
                _player = (ServerPlayer)entity;
                AdvancementHolder _adv = _player.server.getAdvancements().get(ResourceLocation.parse((String)"copperflare:shootwith_fireball_shooter"));
                if (_adv != null && !(_ap = _player.getAdvancements().getOrStartProgress(_adv)).isDone()) {
                    for (String criteria : _ap.getRemainingCriteria()) {
                        _player.getAdvancements().award(_adv, criteria);
                    }
                }
            }
            if (entity instanceof Player) {
                _player = (Player)entity;
                ItemStack _stktoremove = new ItemStack((ItemLike)CopperflareModItems.FIREBALL.get());
                _player.getInventory().clearOrCountMatchingItems(p -> _stktoremove.getItem() == p.getItem(), 1, (Container)_player.inventoryMenu.getCraftSlots());
            }
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"copperflare:fireballshooter-fired")), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"copperflare:fireballshooter-fired")), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                itemstack.hurtAndBreak(1, (ServerLevel)_level, null, _stkprov -> {});
            }
            if (entity instanceof Player) {
                _player = (Player)entity;
                _player.getCooldowns().addCooldown(itemstack, 50);
            }
            if (FireballShooterShootProcedureProcedure.getEntityGameType(entity) == GameType.CREATIVE && entity instanceof Player) {
                _player = (Player)entity;
                ItemStack _setstack = new ItemStack((ItemLike)CopperflareModItems.FIREBALL.get()).copy();
                _setstack.setCount(1);
                ItemHandlerHelper.giveItemToPlayer((Player)_player, (ItemStack)_setstack);
            }
            if (FireballShooterShootProcedureProcedure.getEntityGameType(entity) == GameType.CREATIVE && world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                itemstack.hurtAndBreak(-1, (ServerLevel)_level, null, _stkprov -> {});
            }
        }
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }
}

