/*
 * Decompiled with CFR 0.152.
 */
package com.mosadie.streamercraft;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mosadie.streamercraft.Action;
import com.mosadie.streamercraft.Config;
import com.mosadie.streamercraft.request.DoAction;
import com.mosadie.streamercraft.response.GetActions;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class StreamerCraft {
    public static final String MOD_ID = "streamercraft";
    public static final String TRANSLATION_TRIGGER = "com.mosadie.streamercraft.trigger";
    public static Gson GSON_PRETTY;
    public static Gson GSON_COMPRESSED;
    private static HttpClient httpClient;
    private static Config config;
    public static Logger LOGGER;
    public static final List<Action> actions;

    public static void init() {
        GSON_PRETTY = new GsonBuilder().setPrettyPrinting().create();
        GSON_COMPRESSED = new GsonBuilder().create();
        httpClient = HttpClient.newHttpClient();
        File configFile = Platform.getConfigFolder().resolve("streamercraft.json").toFile();
        if (configFile.exists()) {
            try {
                FileReader reader = new FileReader(configFile);
                config = (Config)GSON_PRETTY.fromJson((Reader)reader, Config.class);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Failed to find config file. Using default config.");
                config = Config.defaultConfig();
            }
            catch (Exception e) {
                LOGGER.error("Failed to read config file. Using default config.");
                config = Config.defaultConfig();
            }
        } else {
            config = Config.defaultConfig();
            try {
                if (configFile.createNewFile()) {
                    LOGGER.info("Created config file.");
                    FileWriter writer = new FileWriter(configFile);
                    GSON_PRETTY.toJson((Object)config, (Appendable)writer);
                    writer.close();
                } else {
                    LOGGER.error("Failed to create default config file.");
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to create config file.");
                LOGGER.error((Object)e);
            }
        }
        StreamerCraft.refreshActionList();
        LOGGER.info("StreamerCraft initialized.");
    }

    private static void refreshActionList() {
        List<Action> newActions = StreamerCraft.getActionList();
        if (newActions != null) {
            actions.clear();
            actions.addAll(newActions);
        }
        LOGGER.info("Refreshed actions.");
    }

    public static List<Action> getActionList() {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + StreamerCraft.config.streamerBotIp + ":" + StreamerCraft.config.streamerBotPort + "/GetActions")).GET().build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            GetActions getActions = (GetActions)GSON_PRETTY.fromJson(response.body(), GetActions.class);
            return List.of(getActions.actions);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get actions from Streamer.bot.");
            LOGGER.error((Object)e);
            return null;
        }
    }

    public static boolean doAction(DoAction doAction) {
        return StreamerCraft.doAction(doAction.getAction(), doAction.getArgs());
    }

    public static boolean doAction(Action action, Map<String, String> args) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + StreamerCraft.config.streamerBotIp + ":" + StreamerCraft.config.streamerBotPort + "/DoAction")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(GSON_PRETTY.toJson((Object)new DoAction(action, args)))).build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            return response.statusCode() == 204;
        }
        catch (Exception e) {
            LOGGER.error("Failed to do action with Streamer.bot.");
            LOGGER.error((Object)e);
            return false;
        }
    }

    public static boolean handleTranslatableContent(class_2588 translatableContents) {
        if (translatableContents.method_11022().equals(TRANSLATION_TRIGGER)) {
            try {
                DoAction doAction = (DoAction)GSON_COMPRESSED.fromJson(translatableContents.method_11023()[0].toString(), DoAction.class);
                boolean result = StreamerCraft.doAction(doAction);
                LOGGER.info("Triggered action: " + doAction.getAction().name + " Result: " + result);
                return result;
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse translatable content.");
                LOGGER.error((Object)e);
            }
        }
        return false;
    }

    public static LiteralArgumentBuilder<class_2168> getNeoForgeCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)MOD_ID).then(class_2170.method_9247((String)"refresh").executes(context -> {
            List<Action> newActions = StreamerCraft.getActionList();
            if (newActions != null) {
                actions.clear();
                actions.addAll(newActions);
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[SC] Refreshed actions.").method_27692(class_124.field_1060));
                return 1;
            }
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[SC] Failed to refresh actions.").method_27692(class_124.field_1061));
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").then(class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.word()).executes(context -> {
            ArrayList<Action> filteredActions = new ArrayList<Action>();
            for (Action action : actions) {
                if (!action.name.contains(StringArgumentType.getString((CommandContext)context, (String)"filter"))) continue;
                filteredActions.add(action);
            }
            if (!filteredActions.isEmpty()) {
                StreamerCraft.SendActionList(filteredActions);
            } else {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[SC] No actions found.").method_27692(class_124.field_1061));
            }
            return 1;
        }))).executes(context -> {
            if (!actions.isEmpty()) {
                StreamerCraft.SendActionList(actions);
            } else {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[SC] No actions found.").method_27692(class_124.field_1061));
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"do").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            Action action = actions.stream().filter(a -> a.id.equals(id)).findFirst().orElse(null);
            if (action != null) {
                if (StreamerCraft.doAction(action, null)) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[SC] Action done.").method_27692(class_124.field_1060));
                } else {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[SC] Failed to do action.").method_27692(class_124.field_1061));
                }
            } else {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[SC] Action not found.").method_27692(class_124.field_1061));
            }
            return 1;
        }))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[SC] Usage: /streamercraft do <id>"));
            return 1;
        }))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[SC] Usage: /streamercraft <refresh|list|do>"));
            return 1;
        });
    }

    public static void SendActionList(List<Action> actions) {
        class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"[SC] Available Actions:").method_27692(class_124.field_1060), false);
        for (Action action : actions) {
            class_5250 header = class_2561.method_43470((String)("--- " + action.name + " ---")).method_27695(new class_124[]{class_124.field_1078, class_124.field_1067});
            class_5250 id = class_2561.method_43470((String)action.id).method_27692(class_124.field_1080).method_27696(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10606(action.id))).method_27696(class_2583.field_24360.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to copy the action ID"))));
            class_5250 blankLine = class_2561.method_43470((String)"\n");
            DoAction doAction = new DoAction(action, new HashMap<String, String>());
            class_5250 tellrawButton = class_2561.method_43470((String)"[Click to copy /tellraw command]").method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)65280)).method_10958((class_2558)new class_2558.class_10606("/tellraw @p " + doAction.getTellRawComponent())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to copy /tellraw command"))));
            class_5250 componentButton = class_2561.method_43470((String)"[Click to copy Translation Component]").method_27696(class_2583.field_24360.method_10977(class_124.field_1065).method_10958((class_2558)new class_2558.class_10606(doAction.getTellRawComponent())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to copy the raw Translation Component JSON"))));
            class_5250 triggerButton = class_2561.method_43470((String)"[Click to manually trigger]").method_27696(class_2583.field_24360.method_10977(class_124.field_1061).method_10958((class_2558)new class_2558.class_10610("/streamercraft do " + action.id)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to manually trigger the action"))));
            class_5250 message = header.method_10852((class_2561)blankLine).method_10852((class_2561)id).method_10852((class_2561)blankLine).method_10852((class_2561)blankLine).method_10852((class_2561)tellrawButton).method_10852((class_2561)blankLine).method_10852((class_2561)componentButton).method_10852((class_2561)blankLine).method_10852((class_2561)triggerButton);
            if (class_310.method_1551().field_1724 == null) continue;
            class_310.method_1551().execute(() -> StreamerCraft.lambda$SendActionList$7(blankLine, (class_2561)message));
        }
    }

    private static /* synthetic */ void lambda$SendActionList$7(class_5250 blankLine, class_2561 message) {
        class_310.method_1551().field_1724.method_7353((class_2561)blankLine, false);
        class_310.method_1551().field_1724.method_7353(message, false);
    }

    static {
        LOGGER = LogManager.getLogger();
        actions = new ArrayList<Action>();
    }
}

