/*
 * Decompiled with CFR 0.152.
 */
package com.mosadie.streamercraft.fabric.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mosadie.streamercraft.Action;
import com.mosadie.streamercraft.StreamerCraft;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_7157;
import net.minecraft.class_7417;

public final class StreamerCraftFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        StreamerCraft.init();
        ClientCommandRegistrationCallback.EVENT.register(this::registerClientCommand);
        ClientReceiveMessageEvents.ALLOW_GAME.register(this::handleGameMessage);
    }

    private boolean handleGameMessage(class_2561 component, boolean b) {
        class_7417 class_74172 = component.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatableContents = (class_2588)class_74172;
            return !StreamerCraft.handleTranslatableContent(translatableContents);
        }
        return true;
    }

    public void registerClientCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 commandBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"streamercraft").then(ClientCommandManager.literal((String)"refresh").executes(context -> {
            List<Action> newActions = StreamerCraft.getActionList();
            if (newActions != null) {
                StreamerCraft.actions.clear();
                StreamerCraft.actions.addAll(newActions);
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"[SC] Refreshed actions.").method_27692(class_124.field_1060));
                return 1;
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"[SC] Failed to refresh actions.").method_27692(class_124.field_1061));
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"list").then(ClientCommandManager.argument((String)"filter", (ArgumentType)StringArgumentType.word()).executes(context -> {
            ArrayList<Action> filteredActions = new ArrayList<Action>();
            for (Action action : StreamerCraft.actions) {
                if (!action.name.contains(StringArgumentType.getString((CommandContext)context, (String)"filter"))) continue;
                filteredActions.add(action);
            }
            if (!filteredActions.isEmpty()) {
                StreamerCraft.LOGGER.info("Filtered actions: " + filteredActions.size());
                StreamerCraft.SendActionList(filteredActions);
            } else {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"[SC] No actions found.").method_27692(class_124.field_1061));
            }
            return 1;
        }))).executes(context -> {
            if (!StreamerCraft.actions.isEmpty()) {
                StreamerCraft.LOGGER.info("All actions: " + StreamerCraft.actions.size());
                StreamerCraft.SendActionList(StreamerCraft.actions);
            } else {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"[SC] No actions found.").method_27692(class_124.field_1061));
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"do").then(ClientCommandManager.argument((String)"id", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            Action action = StreamerCraft.actions.stream().filter(a -> a.id.equals(id)).findFirst().orElse(null);
            if (action != null) {
                if (StreamerCraft.doAction(action, null)) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"[SC] Action done.").method_27692(class_124.field_1060));
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"[SC] Failed to do action.").method_27692(class_124.field_1061));
                }
            } else {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"[SC] Action not found.").method_27692(class_124.field_1061));
            }
            return 1;
        }))).executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"[SC] Usage: /streamercraft do <id>"));
            return 1;
        }))).executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"[SC] Usage: /streamercraft <refresh|list|do>"));
            return 1;
        }));
    }
}

