/*
 * Decompiled with CFR 0.152.
 */
package com.mosadie.streamercraft;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mosadie.streamercraft.Action;
import com.mosadie.streamercraft.request.DoAction;
import com.mosadie.streamercraft.response.GetActions;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class StreamerCraft
extends JavaPlugin
implements Listener {
    public static final String TRANSLATION_TRIGGER = "com.mosadie.streamercraft.trigger";
    public static Gson GSON_PRETTY = new GsonBuilder().setPrettyPrinting().create();
    public static Gson GSON_COMPRESSED = new GsonBuilder().create();
    private static HttpClient httpClient = HttpClient.newHttpClient();
    private FileConfiguration config;
    public final List<Action> actions = new ArrayList<Action>();
    static final Component ACTION_LIST_HEADER = ((TextComponent.Builder)Component.text().content("[SC] Available Actions:").color(TextColor.color((int)0x55FF55))).build();

    public void onEnable() {
        this.config = this.getConfig();
        this.config.addDefault("streamerBotAddress", (Object)"http://127.0.0.1:7474");
        this.config.options().copyDefaults(true);
        this.saveConfig();
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> ((Commands)commands.registrar()).register(this.getCommand().build()));
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.refreshActionList();
        this.getLogger().info("StreamerCraft enabled.");
    }

    private void refreshActionList() {
        List<Action> newActions = this.getActionList();
        if (newActions != null) {
            this.actions.clear();
            this.actions.addAll(newActions);
        }
        this.getLogger().info("Refreshed actions.");
    }

    public List<Action> getActionList() {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.config.getString("streamerBotAddress") + "/GetActions")).header("ngrok-skip-browser-warning", "true").GET().build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            GetActions getActions = (GetActions)GSON_PRETTY.fromJson(response.body(), GetActions.class);
            return List.of(getActions.actions);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to get actions from Streamer.bot.");
            this.getLogger().warning(e.toString());
            return null;
        }
    }

    public boolean doAction(DoAction doAction) {
        return this.doAction(doAction.getAction(), doAction.getArgs());
    }

    public boolean doAction(Action action, Map<String, String> args) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.config.getString("streamerBotAddress") + "/DoAction")).header("Content-Type", "application/json").header("ngrok-skip-browser-warning", "true").POST(HttpRequest.BodyPublishers.ofString(GSON_PRETTY.toJson((Object)new DoAction(action, args)))).build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            return response.statusCode() == 204;
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to do action with Streamer.bot.");
            this.getLogger().warning(e.toString());
            return false;
        }
    }

    public LiteralArgumentBuilder<CommandSourceStack> getCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"streamercraft").then(((LiteralArgumentBuilder)Commands.literal((String)"refresh").requires(sender -> sender.getSender().hasPermission("streamercraft.refresh"))).executes(context -> {
            List<Action> newActions = this.getActionList();
            if (newActions != null) {
                this.actions.clear();
                this.actions.addAll(newActions);
                ((CommandSourceStack)context.getSource()).getSender().sendMessage((Component)((TextComponent.Builder)Component.text().content("[SC] Refreshed actions.").color(TextColor.color((int)0x55FF55))).build());
                return 1;
            }
            ((CommandSourceStack)context.getSource()).getSender().sendMessage((Component)((TextComponent.Builder)Component.text().content("[SC] Failed to refresh actions.").color(TextColor.color((int)0xFF5555))).build());
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(sender -> sender.getSender().hasPermission("streamercraft.list"))).then(Commands.argument((String)"filter", (ArgumentType)StringArgumentType.word()).executes(context -> {
            ArrayList<Action> filteredActions = new ArrayList<Action>();
            for (Action action : this.actions) {
                if (!action.name.contains(StringArgumentType.getString((CommandContext)context, (String)"filter"))) continue;
                filteredActions.add(action);
            }
            if (!filteredActions.isEmpty()) {
                StreamerCraft.SendActionList(filteredActions, (CommandSourceStack)context.getSource());
            } else {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage((Component)((TextComponent.Builder)Component.text().content("[SC] No actions found.").color(TextColor.color((int)0xFF5555))).build());
            }
            return 1;
        }))).executes(context -> {
            if (!this.actions.isEmpty()) {
                StreamerCraft.SendActionList(this.actions, (CommandSourceStack)context.getSource());
            } else {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage((Component)((TextComponent.Builder)Component.text().content("[SC] No actions found.").color(TextColor.color((int)0xFF5555))).build());
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"do").requires(sender -> sender.getSender().hasPermission("streamercraft.do"))).then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            Action action = this.actions.stream().filter(a -> a.id.equals(id)).findFirst().orElse(null);
            if (action != null) {
                if (this.doAction(action, null)) {
                    ((CommandSourceStack)context.getSource()).getSender().sendMessage((Component)((TextComponent.Builder)Component.text().content("[SC] Action done.").color(TextColor.color((int)0x55FF55))).build());
                } else {
                    ((CommandSourceStack)context.getSource()).getSender().sendMessage((Component)((TextComponent.Builder)Component.text().content("[SC] Failed to do action.").color(TextColor.color((int)0xFF5555))).build());
                }
            } else {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage((Component)((TextComponent.Builder)Component.text().content("[SC] Action not found.").color(TextColor.color((int)0xFF5555))).build());
            }
            return 1;
        }))).executes(context -> {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage((ComponentLike)Component.text().content("[SC] Usage: /streamercraft do <id>"));
            return 1;
        }))).executes(context -> {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage((ComponentLike)Component.text().content("[SC] Usage: /streamercraft <refresh|list|do>"));
            return 1;
        });
    }

    public static void SendActionList(List<Action> actions, CommandSourceStack sender) {
        sender.getSender().sendMessage(ACTION_LIST_HEADER);
        for (Action action : actions) {
            BuildableComponent message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(((TextComponent)Component.text((String)("--- " + action.name + " ---")).color(TextColor.color((int)255))).decoration(TextDecoration.BOLD, true))).append((Component)Component.newline())).append(Component.text((String)"ID: ").color(TextColor.color((int)0xAAAAAA)))).append(((TextComponent)((TextComponent)Component.text((String)action.id).color(TextColor.color((int)0xAAAAAA))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.COPY_TO_CLIPBOARD, (String)action.id))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to copy the action ID"))))).append((Component)Component.newline())).append((Component)Component.newline())).append(((TextComponent)((TextComponent)Component.text((String)"[Click to copy /tellraw command]").color(TextColor.color((int)65280))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.COPY_TO_CLIPBOARD, (String)("/tellraw @p " + new DoAction(action, new HashMap<String, String>()).getTellRawComponent())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to copy /tellraw command, for triggering CLIENTS running the mod locally"))))).append((Component)Component.newline())).append(((TextComponent)((TextComponent)Component.text((String)"[Click to copy Paper Command Block command]").color(TextColor.color((int)0xFF55FF))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.COPY_TO_CLIPBOARD, (String)("/streamercraft do " + action.id)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to copy the command for Command Blocks when using the Paper plugin"))))).append((Component)Component.newline())).append(((TextComponent)((TextComponent)Component.text((String)"[Click to copy Translation Component]").color(TextColor.color((int)0xFFAA00))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.COPY_TO_CLIPBOARD, (String)new DoAction(action, new HashMap<String, String>()).getTellRawComponent()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to copy the raw Translation Component JSON"))))).append((Component)Component.newline())).append(((TextComponent)((TextComponent)Component.text((String)"[Click to manually trigger]").color(TextColor.color((int)0xFF5555))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.SUGGEST_COMMAND, (String)("/streamercraft do " + action.id)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to manually trigger the action"))))).build();
            sender.getSender().sendMessage((Component)message);
        }
    }
}

