/*
 * Decompiled with CFR 0.152.
 */
package com.mosadie.streamercraft;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mosadie.streamercraft.Action;
import com.mosadie.streamercraft.Config;
import com.mosadie.streamercraft.request.DoAction;
import com.mosadie.streamercraft.response.GetActions;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class StreamerCraft {
    public static final String MOD_ID = "streamercraft";
    public static final String TRANSLATION_TRIGGER = "com.mosadie.streamercraft.trigger";
    public static Gson GSON_PRETTY;
    public static Gson GSON_COMPRESSED;
    private static HttpClient httpClient;
    private static Config config;
    public static Logger LOGGER;
    public static final List<Action> actions;

    public static void init() {
        GSON_PRETTY = new GsonBuilder().setPrettyPrinting().create();
        GSON_COMPRESSED = new GsonBuilder().create();
        httpClient = HttpClient.newHttpClient();
        File configFile = Platform.getConfigFolder().resolve("streamercraft.json").toFile();
        if (configFile.exists()) {
            try {
                FileReader reader = new FileReader(configFile);
                config = (Config)GSON_PRETTY.fromJson((Reader)reader, Config.class);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Failed to find config file. Using default config.");
                config = Config.defaultConfig();
            }
            catch (Exception e) {
                LOGGER.error("Failed to read config file. Using default config.");
                config = Config.defaultConfig();
            }
        } else {
            config = Config.defaultConfig();
            try {
                if (configFile.createNewFile()) {
                    LOGGER.info("Created config file.");
                    FileWriter writer = new FileWriter(configFile);
                    GSON_PRETTY.toJson((Object)config, (Appendable)writer);
                    writer.close();
                } else {
                    LOGGER.error("Failed to create default config file.");
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to create config file.");
                LOGGER.error((Object)e);
            }
        }
        StreamerCraft.refreshActionList();
        LOGGER.info("StreamerCraft initialized.");
    }

    private static void refreshActionList() {
        List<Action> newActions = StreamerCraft.getActionList();
        if (newActions != null) {
            actions.clear();
            actions.addAll(newActions);
        }
        LOGGER.info("Refreshed actions.");
    }

    public static List<Action> getActionList() {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + StreamerCraft.config.streamerBotIp + ":" + StreamerCraft.config.streamerBotPort + "/GetActions")).GET().build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            GetActions getActions = (GetActions)GSON_PRETTY.fromJson(response.body(), GetActions.class);
            return List.of(getActions.actions);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get actions from Streamer.bot.");
            LOGGER.error((Object)e);
            return null;
        }
    }

    public static boolean doAction(DoAction doAction) {
        return StreamerCraft.doAction(doAction.getAction(), doAction.getArgs());
    }

    public static boolean doAction(Action action, Map<String, String> args) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + StreamerCraft.config.streamerBotIp + ":" + StreamerCraft.config.streamerBotPort + "/DoAction")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(GSON_PRETTY.toJson((Object)new DoAction(action, args)))).build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            return response.statusCode() == 204;
        }
        catch (Exception e) {
            LOGGER.error("Failed to do action with Streamer.bot.");
            LOGGER.error((Object)e);
            return false;
        }
    }

    public static boolean handleTranslatableContent(TranslatableContents translatableContents) {
        if (translatableContents.getKey().equals(TRANSLATION_TRIGGER)) {
            try {
                DoAction doAction = (DoAction)GSON_COMPRESSED.fromJson(translatableContents.getArgs()[0].toString(), DoAction.class);
                boolean result = StreamerCraft.doAction(doAction);
                LOGGER.info("Triggered action: " + doAction.getAction().name + " Result: " + result);
                return result;
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse translatable content.");
                LOGGER.error((Object)e);
            }
        }
        return false;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> getNeoForgeCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)MOD_ID).then(Commands.literal((String)"refresh").executes(context -> {
            List<Action> newActions = StreamerCraft.getActionList();
            if (newActions != null) {
                actions.clear();
                actions.addAll(newActions);
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[SC] Refreshed actions.").withStyle(ChatFormatting.GREEN));
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[SC] Failed to refresh actions.").withStyle(ChatFormatting.RED));
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").then(Commands.argument((String)"filter", (ArgumentType)StringArgumentType.word()).executes(context -> {
            ArrayList<Action> filteredActions = new ArrayList<Action>();
            for (Action action : actions) {
                if (!action.name.contains(StringArgumentType.getString((CommandContext)context, (String)"filter"))) continue;
                filteredActions.add(action);
            }
            if (!filteredActions.isEmpty()) {
                StreamerCraft.SendActionList(filteredActions);
            } else {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[SC] No actions found.").withStyle(ChatFormatting.RED));
            }
            return 1;
        }))).executes(context -> {
            if (!actions.isEmpty()) {
                StreamerCraft.SendActionList(actions);
            } else {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[SC] No actions found.").withStyle(ChatFormatting.RED));
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"do").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            Action action = actions.stream().filter(a -> a.id.equals(id)).findFirst().orElse(null);
            if (action != null) {
                if (StreamerCraft.doAction(action, null)) {
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[SC] Action done.").withStyle(ChatFormatting.GREEN));
                } else {
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[SC] Failed to do action.").withStyle(ChatFormatting.RED));
                }
            } else {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[SC] Action not found.").withStyle(ChatFormatting.RED));
            }
            return 1;
        }))).executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[SC] Usage: /streamercraft do <id>"));
            return 1;
        }))).executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[SC] Usage: /streamercraft <refresh|list|do>"));
            return 1;
        });
    }

    public static void SendActionList(List<Action> actions) {
        Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"[SC] Available Actions:").withStyle(ChatFormatting.GREEN), false);
        for (Action action : actions) {
            MutableComponent header = Component.literal((String)("--- " + action.name + " ---")).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD});
            MutableComponent id = Component.literal((String)action.id).withStyle(ChatFormatting.GRAY).withStyle(Style.EMPTY.withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(action.id))).withStyle(Style.EMPTY.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"Click to copy the action ID"))));
            MutableComponent blankLine = Component.literal((String)"\n");
            DoAction doAction = new DoAction(action, new HashMap<String, String>());
            MutableComponent tellrawButton = Component.literal((String)"[Click to copy /tellraw command]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)65280)).withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard("/tellraw @p " + doAction.getTellRawComponent())).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"Click to copy /tellraw command"))));
            MutableComponent componentButton = Component.literal((String)"[Click to copy Translation Component]").withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD).withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(doAction.getTellRawComponent())).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"Click to copy the raw Translation Component JSON"))));
            MutableComponent triggerButton = Component.literal((String)"[Click to manually trigger]").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/streamercraft do " + action.id)).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"Click to manually trigger the action"))));
            MutableComponent message = header.append((Component)blankLine).append((Component)id).append((Component)blankLine).append((Component)blankLine).append((Component)tellrawButton).append((Component)blankLine).append((Component)componentButton).append((Component)blankLine).append((Component)triggerButton);
            if (Minecraft.getInstance().player == null) continue;
            Minecraft.getInstance().execute(() -> StreamerCraft.lambda$SendActionList$7(blankLine, (Component)message));
        }
    }

    private static /* synthetic */ void lambda$SendActionList$7(MutableComponent blankLine, Component message) {
        Minecraft.getInstance().player.displayClientMessage((Component)blankLine, false);
        Minecraft.getInstance().player.displayClientMessage(message, false);
    }

    static {
        LOGGER = LogManager.getLogger();
        actions = new ArrayList<Action>();
    }
}

