/*
 * Decompiled with CFR 0.152.
 */
package com.mubioh.hymate.mixin;

import com.mubioh.hymate.client.HymateClient;
import com.mubioh.hymate.utils.ServerUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_7438;
import net.minecraft.class_7439;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_634.class})
public class AutoFriendMixin {
    private static final Pattern USERNAME_PATTERN = Pattern.compile("\\b[a-zA-Z0-9_]{3,16}\\b");

    @Inject(method={"onGameMessage"}, at={@At(value="TAIL")})
    private void onGameMessage(class_7439 packet, CallbackInfo ci) {
        try {
            this.handlePacketText(packet.comp_763(), "GameMessage");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Inject(method={"onChatMessage"}, at={@At(value="TAIL")})
    private void onChatMessage(class_7438 packet, CallbackInfo ci) {
        try {
            this.handlePacketText(packet.comp_1103(), "ChatMessage");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void handlePacketText(class_2561 text, String source) {
        if (text == null) {
            return;
        }
        if (!ServerUtils.isOnHypixel()) {
            return;
        }
        if (!HymateClient.config.autoAcceptFriendRequests) {
            return;
        }
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        String raw = text.getString();
        System.out.println("[" + source + "] raw: " + raw);
        String stripped = ServerUtils.stripFormatting(raw).trim();
        System.out.println("[" + source + "] stripped: " + stripped.replace("\n", "\\n"));
        if (!stripped.toLowerCase().contains("friend request from")) {
            return;
        }
        String after = stripped.replaceFirst("(?i).*friend request from", "").trim();
        Matcher m = USERNAME_PATTERN.matcher(after = after.replaceAll("\\[[^]]*]", "").trim());
        if (m.find()) {
            String playerName = m.group();
            System.out.println("Found friend request from: " + playerName);
            class_310.method_1551().field_1724.field_3944.method_45730("friend accept " + playerName);
        } else {
            System.out.println("Could not find username in: " + after.replace("\n", "\\n"));
        }
    }
}

