/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.PermissionsFactory;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.config.GitConfigKey;
import net.pcal.fastback.config.OtherConfigKey;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.utils.Executor;
import net.pcal.fastback.utils.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.StoredConfig;

enum CreateFileRemoteCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "create-file-remote";
    private static final String ARGUMENT = "file-path";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, PermissionsFactory<class_2168> pf) {
        argb.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(COMMAND_NAME, pf))).executes(cc -> Commands.missingArgument(ARGUMENT, (CommandContext<class_2168>)cc))).then(class_2170.method_9244((String)ARGUMENT, (ArgumentType)StringArgumentType.greedyString()).executes(CreateFileRemoteCommand::setFileRemote)));
    }

    private static int setFileRemote(CommandContext<class_2168> cc) {
        UserLogger ulog = UserLogger.ulog(cc);
        Commands.gitOp(Executor.ExecutionLock.NONE, ulog, repo -> {
            String targetPath = (String)cc.getArgument(ARGUMENT, String.class);
            Path fupHome = Path.of(targetPath, new String[0]);
            if (fupHome.toFile().exists()) {
                ulog.message(UserMessage.styledLocalized("fastback.chat.create-file-remote-dir-exists", UserMessage.UserMessageStyle.ERROR, fupHome.toString()));
                return;
            }
            FileUtils.mkdirs(fupHome);
            GitConfig conf = repo.getConfig();
            try (Git targetGit = Git.init().setBare(conf.getBoolean(FastbackConfigKey.IS_FILE_REMOTE_BARE)).setDirectory(fupHome.toFile()).call();){
                StoredConfig targetGitc = targetGit.getRepository().getConfig();
                targetGitc.setInt("pack", null, "window", 0);
                targetGitc.setInt("core", null, "bigFileThreshold", 1);
                targetGitc.save();
            }
            String targetUrl = "file://" + String.valueOf(fupHome.toAbsolutePath());
            repo.getConfig().updater().set((GitConfigKey)OtherConfigKey.REMOTE_PUSH_URL, targetUrl).save();
            ulog.message(UserMessage.localized("fastback.chat.create-file-remote-created", targetPath, targetUrl));
        });
        return 1;
    }
}

