/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.logging;

import java.util.Objects;

public record UserMessage(LocalizedUserMessage localized, String raw, UserMessageStyle style) {
    public static UserMessage localized(String key, Object ... params) {
        return UserMessage.styledLocalized(key, UserMessageStyle.NORMAL, params);
    }

    public static UserMessage styledLocalized(String key, UserMessageStyle style, Object ... params) {
        return new UserMessage(new LocalizedUserMessage(key, params), null, style);
    }

    public static UserMessage raw(String text) {
        return UserMessage.styledRaw(text, UserMessageStyle.NORMAL);
    }

    public static UserMessage styledRaw(String text, UserMessageStyle style) {
        return new UserMessage(null, Objects.requireNonNull(text), style);
    }

    @Override
    public String toString() {
        return this.raw != null ? this.raw : (this.localized != null ? this.localized.toString() : null);
    }

    @Deprecated
    public static UserMessage localizedError(String key, Object ... params) {
        return UserMessage.styledLocalized(key, UserMessageStyle.ERROR, params);
    }

    @Deprecated
    public static UserMessage rawError(String text) {
        return UserMessage.styledRaw(text, UserMessageStyle.ERROR);
    }

    public record LocalizedUserMessage(String key, Object[] params) {
        @Override
        public String toString() {
            return this.key + " " + String.valueOf(this.params != null ? this.params : "[]");
        }
    }

    public static enum UserMessageStyle {
        NORMAL,
        WARNING,
        ERROR,
        JGIT,
        NATIVE_GIT,
        BROADCAST;

    }
}

