/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.mod.fabric;

import java.nio.file.Path;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_424;
import net.minecraft.class_437;
import net.minecraft.class_9779;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.MinecraftProvider;
import net.pcal.fastback.mod.fabric.BaseFabricProvider;
import net.pcal.fastback.mod.fabric.mixins.ScreenAccessors;

final class FabricClientProvider
extends BaseFabricProvider
implements HudRenderCallback {
    private static final long TEXT_TIMEOUT = 10000L;
    private class_310 client = null;
    private class_2561 hudText;
    private long hudTextTime;

    FabricClientProvider() {
    }

    public void setMinecraftClient(class_310 client) {
        if (this.client == null == (client == null)) {
            throw new IllegalStateException();
        }
        this.client = client;
    }

    @Override
    public void renderMessageScreen(class_332 guiGraphics) {
        this.renderHud(guiGraphics);
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void setHudText(UserMessage userMessage) {
        if (userMessage == null) {
            this.clearHudText();
        } else {
            this.hudText = MinecraftProvider.messageToText(userMessage);
            this.hudTextTime = System.currentTimeMillis();
        }
    }

    @Override
    public void clearHudText() {
        this.hudText = null;
    }

    @Override
    public void setMessageScreenText(UserMessage userMessage) {
        if (this.client == null) {
            return;
        }
        class_437 screen = this.client.field_1755;
        if (screen instanceof class_424) {
            ((ScreenAccessors)screen).setTitle(MinecraftProvider.messageToText(userMessage));
        }
    }

    @Override
    public Path getSavesDir() {
        return FabricLoader.getInstance().getGameDir().resolve("saves");
    }

    public void onHudRender(class_332 drawContext, class_9779 tickDelta) {
        this.renderHud(drawContext);
    }

    private void renderHud(class_332 guiGraphics) {
        if (this.client == null) {
            return;
        }
        if (this.hudText == null) {
            return;
        }
        if (!((Boolean)this.client.field_1690.method_42452().method_41753()).booleanValue()) {
            return;
        }
        if (System.currentTimeMillis() - this.hudTextTime > 10000L) {
            this.hudText = null;
            SystemLogger.syslog().debug("hud text timed out.  somebody forgot to clean up");
            return;
        }
        guiGraphics.method_27535(this.client.field_1772, this.hudText, 2, 2, 1);
    }
}

