/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.repo.JGitSupplier;
import net.pcal.fastback.repo.RepoImpl;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.repo.SnapshotIdUtils;
import org.eclipse.jgit.api.errors.GitAPIException;

abstract class BranchUtils {
    BranchUtils() {
    }

    static Set<SnapshotId> listSnapshots(RepoImpl repo, JGitSupplier<Collection<String>> refProvider) throws GitAPIException, IOException {
        Collection<String> refs = refProvider.get();
        SnapshotIdUtils.SnapshotIdCodec codec = repo.getSidCodec();
        HashSet<SnapshotId> out = new HashSet<SnapshotId>();
        for (String ref : refs) {
            String branchName = BranchUtils.getBranchName(ref);
            if (repo.getSidCodec().isSnapshotBranchName(repo.getWorldId(), branchName)) {
                SnapshotId sid;
                try {
                    sid = Objects.requireNonNull(codec.fromBranch(branchName));
                }
                catch (ParseException pe) {
                    SystemLogger.syslog().error("Unexpected parse error, ignoring branch " + branchName, pe);
                    continue;
                }
                if (sid.getWorldId().equals(repo.getWorldId())) {
                    out.add(sid);
                    continue;
                }
                SystemLogger.syslog().debug("Ignoring branch from other world " + branchName);
                continue;
            }
            SystemLogger.syslog().debug("Ignoring unrecognized branch " + branchName);
        }
        return out;
    }

    static String getBranchName(String name) {
        String REFS_HEADS = "refs/heads/";
        if (name.startsWith("refs/heads/")) {
            return name.substring("refs/heads/".length());
        }
        return null;
    }
}

