/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import java.util.Objects;
import org.eclipse.jgit.lib.ProgressMonitor;

class JGitIncrementalProgressMonitor
implements ProgressMonitor {
    private final ProgressMonitor delegate;
    private final int totalIncrements;
    private int workComplete;
    private int totalWork;
    private int workCompletedInIncrement;
    private int workCompleteScaled;

    public JGitIncrementalProgressMonitor(ProgressMonitor delegate, int totalIncrements) {
        this.delegate = Objects.requireNonNull(delegate);
        this.totalIncrements = totalIncrements;
    }

    public void start(int totalTasks) {
        this.delegate.start(totalTasks);
    }

    public void beginTask(String taskName, int totalWork) {
        this.delegate.beginTask(taskName, totalWork);
        this.totalWork = totalWork;
        this.workComplete = 0;
        this.workCompleteScaled = 0;
        this.workCompletedInIncrement = 0;
    }

    public void update(int completed) {
        this.workComplete += completed;
        this.workCompletedInIncrement += completed;
        if (this.totalWork == 0) {
            return;
        }
        int newWorkCompleteScaled = this.workComplete * this.totalIncrements / this.totalWork;
        if (newWorkCompleteScaled > this.workCompleteScaled) {
            this.workCompleteScaled = newWorkCompleteScaled;
            this.delegate.update(this.workCompletedInIncrement);
            this.workCompletedInIncrement = 0;
        }
    }

    public void endTask() {
        this.delegate.endTask();
    }

    public boolean isCancelled() {
        return false;
    }

    public void showDuration(boolean enabled) {
    }
}

