/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.repo.RepoImpl;
import net.pcal.fastback.repo.WorldIdUtils;
import net.pcal.fastback.utils.FileUtils;
import net.pcal.fastback.utils.ProcessException;
import net.pcal.fastback.utils.ProcessUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.StoredConfig;

abstract class PreflightUtils {
    PreflightUtils() {
    }

    static void doPreflight(RepoImpl repo) throws IOException, ProcessException, GitAPIException {
        Path targetPath;
        SystemLogger syslog = SystemLogger.syslog();
        syslog.debug("Doing world maintenance");
        Git jgit = repo.getJGit();
        Path worldSaveDir = jgit.getRepository().getWorkTree().toPath();
        WorldIdUtils.ensureWorldHasId(worldSaveDir);
        GitConfig config = GitConfig.load(jgit);
        if (config.getBoolean(FastbackConfigKey.UPDATE_GITIGNORE_ENABLED)) {
            targetPath = worldSaveDir.resolve(".gitignore");
            FileUtils.writeResourceToFile("world/gitignore", targetPath);
        }
        if (config.getBoolean(FastbackConfigKey.UPDATE_GITATTRIBUTES_ENABLED)) {
            targetPath = worldSaveDir.resolve(".gitattributes");
            if (config.getBoolean(FastbackConfigKey.IS_NATIVE_GIT_ENABLED)) {
                FileUtils.writeResourceToFile("world/gitattributes-native", targetPath);
            } else {
                FileUtils.writeResourceToFile("world/gitattributes-jgit", targetPath);
            }
        }
        PreflightUtils.updateNativeLfsInstallation(repo);
    }

    private static void updateNativeLfsInstallation(RepoImpl repo) throws ProcessException, GitAPIException {
        if (repo.getConfig().getBoolean(FastbackConfigKey.IS_NATIVE_GIT_ENABLED)) {
            String[] cmd = new String[]{"git", "-C", repo.getWorkTree().getAbsolutePath(), "lfs", "install", "--local"};
            ProcessUtils.doExec(cmd, Collections.emptyMap(), s -> {}, s -> {});
        } else {
            try {
                StoredConfig jgitConfig = repo.getJGit().getRepository().getConfig();
                jgitConfig.unsetSection("lfs", null);
                jgitConfig.unsetSection("filter", "lfs");
                jgitConfig.save();
            }
            catch (Exception ohwell) {
                SystemLogger.syslog().debug(ohwell);
            }
        }
    }
}

