/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.repo.JGitConsumer;
import net.pcal.fastback.repo.JGitSupplier;
import net.pcal.fastback.repo.Repo;
import net.pcal.fastback.repo.RepoImpl;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyCodec;
import net.pcal.fastback.retention.RetentionPolicyType;
import net.pcal.fastback.utils.ProcessException;
import net.pcal.fastback.utils.ProcessUtils;
import org.apache.commons.lang3.function.Consumers;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.RefSpec;

abstract class PruneUtils {
    PruneUtils() {
    }

    static void deleteRemoteBranch(RepoImpl repo, String remoteBranchName) throws IOException {
        GitConfig config = repo.getConfig();
        try {
            if (config.getBoolean(FastbackConfigKey.IS_NATIVE_GIT_ENABLED)) {
                PruneUtils.native_deleteRemoteBranch(repo, remoteBranchName);
            } else {
                PruneUtils.jgit_deleteRemoteBranch(repo, remoteBranchName);
            }
        }
        catch (ProcessException | GitAPIException e) {
            throw new IOException(e);
        }
    }

    static void native_deleteRemoteBranch(RepoImpl repo, String remoteBranchName) throws ProcessException {
        String[] command = new String[]{"git", "-C", repo.getWorkTree().getAbsolutePath(), "push", repo.getConfig().getString(FastbackConfigKey.REMOTE_NAME), "--delete", remoteBranchName};
        ProcessUtils.doExec(command, Collections.emptyMap(), Consumers.nop(), Consumers.nop(), true);
    }

    static void jgit_deleteRemoteBranch(RepoImpl repo, String remoteBranchName) throws GitAPIException {
        RefSpec refSpec = new RefSpec().setSource(null).setDestination("refs/heads/" + remoteBranchName);
        repo.getJGit().push().setRefSpecs(new RefSpec[]{refSpec}).setRemote(remoteBranchName).call();
    }

    static void deleteLocalBranches(RepoImpl repo, List<String> branchNames) throws IOException {
        try {
            repo.getJGit().branchDelete().setForce(true).setBranchNames(branchNames.toArray(new String[0])).call();
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }

    static Collection<SnapshotId> doLocalPrune(RepoImpl repo, UserLogger log) throws IOException {
        return PruneUtils.doPrune(repo, log, FastbackConfigKey.LOCAL_RETENTION_POLICY, repo::getLocalSnapshots, sid -> {
            SystemLogger.syslog().info("Pruning local snapshot " + sid.getBranchName());
            PruneUtils.deleteLocalBranches(repo, List.of(sid.getBranchName()));
        }, "fastback.chat.retention-policy-not-set");
    }

    static Collection<SnapshotId> doRemotePrune(RepoImpl repo, UserLogger ulog) throws IOException {
        return PruneUtils.doPrune(repo, ulog, FastbackConfigKey.REMOTE_RETENTION_POLICY, repo::getRemoteSnapshots, sid -> {
            SystemLogger.syslog().info("Pruning remote snapshot " + sid.getBranchName());
            repo.deleteRemoteBranch(sid.getBranchName());
        }, "fastback.chat.remote-retention-policy-not-set");
    }

    private static Collection<SnapshotId> doPrune(Repo repo, UserLogger log, FastbackConfigKey policyConfigKey, JGitSupplier<Set<SnapshotId>> listSnapshotsFn, JGitConsumer<SnapshotId> deleteSnapshotsFn, String notSetKey) throws IOException {
        GitConfig conf = repo.getConfig();
        RetentionPolicy policy = null;
        String policyConfig = conf.getString(policyConfigKey);
        if (policyConfig != null) {
            policy = RetentionPolicyCodec.INSTANCE.decodePolicy(RetentionPolicyType.getAvailable(), policyConfig);
        }
        if (policy == null) {
            log.message(UserMessage.styledLocalized(notSetKey, UserMessage.UserMessageStyle.ERROR, new Object[0]));
            return null;
        }
        Collection<SnapshotId> toPruneUnsorted = policy.getSnapshotsToPrune(listSnapshotsFn.get());
        ArrayList<SnapshotId> toPrune = new ArrayList<SnapshotId>(toPruneUnsorted);
        Collections.sort(toPrune);
        log.update(UserMessage.localized("fastback.hud.prune-started", new Object[0]));
        for (SnapshotId sid : toPrune) {
            deleteSnapshotsFn.accept(sid);
        }
        return toPrune;
    }
}

