/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.config.GitConfigKey;
import net.pcal.fastback.config.OtherConfigKey;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.repo.Repo;
import net.pcal.fastback.repo.RepoFactory;
import net.pcal.fastback.repo.RepoImpl;
import net.pcal.fastback.repo.WorldIdUtils;
import net.pcal.fastback.utils.EnvironmentUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.StoredConfig;

class RepoFactoryImpl
implements RepoFactory {
    RepoFactoryImpl() {
    }

    @Override
    public void doInit(Path worldSaveDir, UserLogger ulog) throws IOException {
        if (this.isGitRepo(worldSaveDir)) {
            WorldIdUtils.ensureWorldHasId(worldSaveDir);
            ulog.message(UserMessage.styledLocalized("fastback.chat.enabled", UserMessage.UserMessageStyle.WARNING, new Object[0]));
            return;
        }
        if (!EnvironmentUtils.isNativeOk(true, ulog, true)) {
            throw new IOException();
        }
        try (Git jgit = Git.init().setDirectory(worldSaveDir.toFile()).call();){
            WorldIdUtils.createWorldId(worldSaveDir);
            RepoImpl repo = new RepoImpl(jgit);
            GitConfig.Updater updater = repo.getConfig().updater();
            updater.set((GitConfigKey)OtherConfigKey.COMMIT_SIGNING_ENABLED, false);
            updater.set((GitConfigKey)FastbackConfigKey.IS_NATIVE_GIT_ENABLED, true);
            StoredConfig config = jgit.getRepository().getConfig();
            String userName = config.getString("user", null, "name");
            String userEmail = config.getString("user", null, "email");
            if (userName == null || userName.isEmpty() || userEmail == null || userEmail.isEmpty()) {
                String worldId = WorldIdUtils.getWorldIdInfo(worldSaveDir).wid().toString();
                config.setString("user", null, "name", worldId);
                config.setString("user", null, "email", worldId + "@fastback");
            }
            updater.save();
            ulog.message(UserMessage.raw("Backups initialized.  Run '/backup local' to do your first backup.  '/backup help' for more options."));
        }
        catch (GitAPIException e) {
            SystemLogger.syslog().error("Error initializing repo", e);
            throw new IOException(e);
        }
    }

    @Override
    public boolean doInitCheck(Path worldSaveDir, UserLogger ulog) {
        if (!this.isGitRepo(worldSaveDir)) {
            ulog.message(UserMessage.styledRaw("Please run '/backup init' first.", UserMessage.UserMessageStyle.ERROR));
            return false;
        }
        return true;
    }

    @Override
    public Repo load(Path worldSaveDir) throws IOException {
        Git jgit = Git.open((File)worldSaveDir.toFile());
        WorldIdUtils.ensureWorldHasId(worldSaveDir);
        return new RepoImpl(jgit);
    }

    @Override
    public boolean isGitRepo(Path worldSaveDir) {
        File dotGit = worldSaveDir.resolve(".git").toFile();
        return dotGit.exists() && dotGit.isDirectory();
    }
}

