/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Random;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.repo.SnapshotIdUtils;
import net.pcal.fastback.repo.WorldId;
import net.pcal.fastback.utils.FileUtils;

abstract class WorldIdUtils {
    private static final Path WORLD_ID_PATH = Path.of(".fastback/world-id", new String[0]);
    private static final int WORLD_ID_LENGTH = 4;
    @Deprecated
    private static final Path OLD_WORLD_UUID_PATH = Path.of(".fastback/world.uuid", new String[0]);
    private static final char[] BASE58_CHARS = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();

    WorldIdUtils() {
    }

    static WorldIdInfo getWorldIdInfo(Path worldSaveDir) throws IOException {
        WorldIdUtils.migrateFastbackDir(worldSaveDir);
        Path idPath = worldSaveDir.resolve(WORLD_ID_PATH);
        if (idPath.toFile().exists()) {
            WorldIdImpl wid = new WorldIdImpl(Objects.requireNonNull(Files.readString(idPath).trim()));
            return new WorldIdInfo(wid, SnapshotIdUtils.SnapshotIdCodec.V2);
        }
        Path uuidPath = worldSaveDir.resolve(OLD_WORLD_UUID_PATH);
        if (uuidPath.toFile().exists()) {
            WorldIdImpl wid = new WorldIdImpl(Objects.requireNonNull(Files.readString(uuidPath).trim()));
            return new WorldIdInfo(wid, SnapshotIdUtils.SnapshotIdCodec.V1);
        }
        throw new FileNotFoundException(WORLD_ID_PATH.toString());
    }

    static void createWorldId(Path worldSaveDir) throws IOException {
        WorldIdUtils.migrateFastbackDir(worldSaveDir);
        Path worldIdPath = worldSaveDir.resolve(WORLD_ID_PATH).toAbsolutePath().normalize();
        if (worldIdPath.toFile().exists()) {
            SystemLogger.syslog().debug(String.valueOf(worldIdPath) + " already exists, skipping id creation");
            return;
        }
        FileUtils.mkdirs(worldIdPath.getParent());
        String worldId = WorldIdUtils.generateRandomWorldId(4);
        try (FileWriter fw = new FileWriter(worldIdPath.toFile());){
            fw.append(worldId);
            fw.append('\n');
        }
        SystemLogger.syslog().debug("Wrote new worldId " + worldId + " to " + String.valueOf(worldIdPath));
    }

    static void ensureWorldHasId(Path worldSaveDir) throws IOException {
        WorldIdUtils.migrateFastbackDir(worldSaveDir);
        Path worldIdPath = worldSaveDir.resolve(WORLD_ID_PATH).toAbsolutePath().normalize();
        if (!worldIdPath.toFile().exists()) {
            SystemLogger.syslog().warn("Did not find expected id file at " + String.valueOf(worldIdPath));
            SystemLogger.syslog().warn("We'll create a new one and carry on.  But this indicates something weird is going on.");
            WorldIdUtils.createWorldId(worldSaveDir);
        }
    }

    static String generateRandomWorldId(int length) {
        StringBuilder out = new StringBuilder();
        Random r = new Random();
        for (int i = 0; i < length; ++i) {
            out.append(BASE58_CHARS[r.nextInt(BASE58_CHARS.length)]);
        }
        return out.toString();
    }

    private static void migrateFastbackDir(Path worldSaveDir) {
        File newDir;
        File oldDir = worldSaveDir.resolve("fastback").toAbsolutePath().normalize().toFile();
        if (oldDir.exists() && !(newDir = worldSaveDir.resolve(".fastback").toAbsolutePath().normalize().toFile()).exists()) {
            if (oldDir.renameTo(newDir)) {
                SystemLogger.syslog().info("moved " + String.valueOf(oldDir) + " to " + String.valueOf(newDir));
            } else {
                SystemLogger.syslog().error("failed to move " + String.valueOf(oldDir) + " to " + String.valueOf(newDir));
            }
        }
    }

    record WorldIdImpl(String id) implements WorldId
    {
        @Override
        public String toString() {
            return this.id;
        }
    }

    record WorldIdInfo(WorldId wid, SnapshotIdUtils.SnapshotIdCodec sidCodec) {
    }
}

