/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.retention;

import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Supplier;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyType;

class GFSRetentionPolicy
implements RetentionPolicy {
    private static final String L10N_KEY = "fastback.retain.gfs.description";
    Supplier<LocalDate> nowSupplier = () -> LocalDate.now(TimeZone.getDefault().toZoneId());

    @Override
    public UserMessage getDescription() {
        return UserMessage.localized(L10N_KEY, new Object[0]);
    }

    @Override
    public Collection<SnapshotId> getSnapshotsToPrune(Set<SnapshotId> snapshots) {
        ArrayList<SnapshotId> toPrune = new ArrayList<SnapshotId>();
        LocalDate now = this.nowSupplier.get();
        LocalDate gracePeriodStart = now.minus(Period.ofDays(2));
        LocalDate oneWeekAgo = now.minus(Period.ofDays(7));
        LocalDate oneMonthAgo = now.minus(Period.ofDays(30));
        Integer currentDay = null;
        Integer currentWeek = null;
        Integer currentMonth = null;
        ArrayList<SnapshotId> sortedDesending = new ArrayList<SnapshotId>(snapshots);
        Collections.sort(sortedDesending, Collections.reverseOrder());
        for (SnapshotId sid : sortedDesending) {
            LocalDate snapshotDate = sid.getDate().toInstant().atZone(TimeZone.getDefault().toZoneId()).toLocalDate();
            if (snapshotDate.isAfter(gracePeriodStart)) {
                SystemLogger.syslog().debug("Will retain " + String.valueOf(sid) + " because still in the grace period");
                continue;
            }
            if (snapshotDate.isAfter(oneWeekAgo)) {
                int snapshotDay = snapshotDate.get(ChronoField.DAY_OF_MONTH);
                if (currentDay == null || currentDay != snapshotDay) {
                    currentDay = snapshotDay;
                    continue;
                }
                toPrune.add(sid);
                continue;
            }
            if (snapshotDate.isAfter(oneMonthAgo)) {
                int snapshotWeek = snapshotDate.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
                if (currentWeek == null || currentWeek != snapshotWeek) {
                    currentWeek = snapshotWeek;
                    continue;
                }
                toPrune.add(sid);
                continue;
            }
            int snapshotMonth = snapshotDate.get(ChronoField.MONTH_OF_YEAR);
            if (currentMonth == null || snapshotMonth != currentMonth) {
                currentMonth = snapshotMonth;
                continue;
            }
            toPrune.add(sid);
        }
        return toPrune;
    }

    public static enum GFSRetentionPolicyType implements RetentionPolicyType
    {
        INSTANCE;


        @Override
        public String getName() {
            return "gfs";
        }

        @Override
        public List<RetentionPolicyType.Parameter<?>> getParameters() {
            return Collections.emptyList();
        }

        @Override
        public RetentionPolicy createPolicy(Map<String, String> config) {
            return new GFSRetentionPolicy();
        }

        @Override
        public UserMessage getDescription() {
            return UserMessage.localized(GFSRetentionPolicy.L10N_KEY, new Object[0]);
        }
    }
}

