/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.utils;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.utils.ProcessException;
import net.pcal.fastback.utils.ProcessUtils;

public class EnvironmentUtils {
    public static String getGitVersion() {
        return EnvironmentUtils.execForVersion(new String[]{"git", "--version"});
    }

    public static String getGitLfsVersion() {
        return EnvironmentUtils.execForVersion(new String[]{"git", "lfs", "--version"});
    }

    public static boolean isNativeOk(GitConfig conf, UserLogger ulog, boolean verbose) {
        return EnvironmentUtils.isNativeOk(conf.getBoolean(FastbackConfigKey.IS_NATIVE_GIT_ENABLED), ulog, verbose);
    }

    public static boolean isNativeOk(boolean isNativeGitEnabled, UserLogger ulog, boolean verbose) {
        if (isNativeGitEnabled) {
            class_5250 notInstalled = class_2561.method_43471((String)"fastback.values.not-installed");
            String gitVersion = EnvironmentUtils.getGitVersion();
            String gitLfsVersion = EnvironmentUtils.getGitLfsVersion();
            if (verbose) {
                ulog.message(UserMessage.localized("fastback.chat.native-info", gitVersion != null ? gitVersion : notInstalled, gitLfsVersion != null ? gitLfsVersion : notInstalled));
            }
            if (gitVersion == null) {
                ulog.message(UserMessage.styledLocalized("fastback.chat.native-git-not-installed", UserMessage.UserMessageStyle.ERROR, System.getenv("PATH")));
                return false;
            }
            if (gitLfsVersion == null) {
                ulog.message(UserMessage.styledLocalized("fastback.chat.native-lfs-not-installed", UserMessage.UserMessageStyle.ERROR, System.getenv("PATH")));
                return false;
            }
        } else if (verbose) {
            ulog.message(UserMessage.styledLocalized("fastback.chat.native-disabled", UserMessage.UserMessageStyle.WARNING, new Object[0]));
        }
        return true;
    }

    private static String execForVersion(String[] cmd) {
        int exit;
        ArrayList stdout = new ArrayList();
        try {
            exit = ProcessUtils.doExec(cmd, Collections.emptyMap(), stdout::add, line -> {});
        }
        catch (ProcessException e) {
            SystemLogger.syslog().debug("Could not run " + String.join((CharSequence)" ", cmd), e);
            return null;
        }
        return exit == 0 ? (String)stdout.get(0) : null;
    }
}

