/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.utils;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class ProcessException
extends Exception {
    private final List<String> processOutput;

    ProcessException(String[] args, int exitCode, List<String> processOutput, Throwable nested) {
        super("Exit " + exitCode + " when executing: " + String.join((CharSequence)" ", args), nested);
        this.processOutput = Objects.requireNonNull(processOutput);
    }

    ProcessException(String[] args, int exitCode, List<String> stdoutLines) {
        super("Exit " + exitCode + " when executing: " + String.join((CharSequence)" ", args));
        this.processOutput = Objects.requireNonNull(stdoutLines);
    }

    public void writeProcessOutput(Consumer<String> consumer) {
        for (String line : this.processOutput) {
            consumer.accept(line);
        }
    }
}

