/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.utils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.utils.ProcessException;

public class ProcessUtils {
    public static int doExec(String[] args, Map<String, String> envOriginal, Consumer<String> stdoutSink, Consumer<String> stderrSink) throws ProcessException {
        return ProcessUtils.doExec(args, envOriginal, stdoutSink, stderrSink, true);
    }

    public static int doExec(String[] args, Map<String, String> envOriginal, Consumer<String> stdoutSink, Consumer<String> stderrSink, boolean throwOnNonZero) throws ProcessException {
        int exit;
        SystemLogger.syslog().debug("Executing " + String.join((CharSequence)" ", args));
        ProcessBuilder pb = new ProcessBuilder(args);
        Map<String, String> env = pb.environment();
        SystemLogger.syslog().debug("PATH: " + env.get("PATH"));
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            SystemLogger.syslog().debug("HOME: " + env.get("USERPROFILE"));
            SystemLogger.syslog().debug("USER: " + env.get("USERNAME"));
        } else {
            SystemLogger.syslog().debug("HOME: " + env.get("HOME"));
            SystemLogger.syslog().debug("USER: " + env.get("USER"));
        }
        ArrayList<String> errorBuffer = new ArrayList<String>();
        Consumer<String> stdout = line -> {
            SystemLogger.syslog().debug("[STDOUT] " + line);
            stdoutSink.accept((String)line);
            errorBuffer.add("[STDOUT] " + line);
        };
        Consumer<String> stderr = line -> {
            SystemLogger.syslog().debug("[STDERR] " + line);
            stderrSink.accept((String)line);
            errorBuffer.add("[STDERR] " + line);
        };
        try {
            Process p = pb.start();
            exit = ProcessUtils.drainAndWait(p, new LineWriter(stdout), new LineWriter(stderr));
        }
        catch (IOException | InterruptedException e) {
            throw new ProcessException(args, 0, errorBuffer, e);
        }
        if (throwOnNonZero && exit != 0) {
            throw new ProcessException(args, exit, errorBuffer);
        }
        return exit;
    }

    private static int drainAndWait(Process process, Writer stdoutSink, Writer stderrSink) throws IOException, InterruptedException {
        InputStreamReader stdoutReader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
        InputStreamReader stderrReader = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
        char[] buffer = new char[1024];
        while (true) {
            int read;
            boolean readAny = false;
            if (stdoutReader != null && ((Reader)stdoutReader).ready()) {
                read = ((Reader)stdoutReader).read(buffer, 0, buffer.length);
                if (read < 0) {
                    stdoutReader = null;
                } else if (read > 0) {
                    readAny = true;
                    stdoutSink.write(buffer, 0, read);
                }
            }
            if (stderrReader != null && ((Reader)stderrReader).ready()) {
                read = ((Reader)stderrReader).read(buffer, 0, buffer.length);
                if (read < 0) {
                    stderrReader = null;
                } else if (read > 0) {
                    readAny = true;
                    stderrSink.write(buffer, 0, read);
                }
            }
            if (readAny) continue;
            if (!process.isAlive()) {
                return process.exitValue();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                process.destroy();
                throw ie;
            }
        }
    }

    private static class LineWriter
    extends Writer {
        private final Consumer<String> sink;
        private final StringBuilder buffer = new StringBuilder();

        private LineWriter(Consumer<String> sink) {
            this.sink = Objects.requireNonNull(sink);
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            this.buffer.append(cbuf, off, len);
            this.outputLines();
        }

        private void outputLines() {
            int lineEnd;
            int lineStart = 0;
            while ((lineEnd = LineWriter.findLineEnd(this.buffer, lineStart)) != -1) {
                String line = this.buffer.substring(lineStart, lineEnd).trim();
                if (line.length() > 0) {
                    this.sink.accept(line);
                }
                lineStart = lineEnd + 1;
            }
            if (lineStart != 0) {
                this.buffer.delete(0, lineStart);
            }
        }

        private static int findLineEnd(StringBuilder buffer, int lineStart) {
            int newLine = buffer.indexOf("\n", lineStart);
            int carriage = buffer.indexOf("\r", lineStart);
            if (newLine == -1) {
                return carriage;
            }
            if (carriage == -1) {
                return newLine;
            }
            return Math.min(newLine, carriage);
        }

        @Override
        public void flush() {
            this.outputLines();
            if (this.buffer.length() > 0) {
                this.sink.accept(this.buffer.toString());
            }
        }

        @Override
        public void close() {
        }
    }
}

