/*
 * Decompiled with CFR 0.152.
 */
package com.stromblex.modpackchecker;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.stromblex.modpackchecker.MinecraftVersionToast;
import com.stromblex.modpackchecker.ModpackChecker;
import com.stromblex.modpackchecker.ModpackConfig;
import com.stromblex.modpackchecker.UpdateScreen;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class UpdateChecker {
    private static final Gson GSON = new Gson();
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    public static String lastDownloadUrl = null;
    private static String pendingVersion = null;
    private static String pendingDownloadUrl = null;
    private static String pendingChangelog = null;
    private static boolean shownMinecraftVersionToast = false;

    public static void checkForUpdates() {
        ModpackChecker.LOGGER.info("Checking for updates...");
        String updateUrl = ModpackConfig.getUpdateUrl();
        if (updateUrl == null || updateUrl.isEmpty()) {
            ModpackChecker.LOGGER.warn("Update URL not configured in config file");
            return;
        }
        ModpackChecker.LOGGER.info("Update URL: {}", (Object)updateUrl);
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(ModpackConfig.getNotificationDelay());
                ModpackChecker.LOGGER.info("Making HTTP request to: {}", (Object)updateUrl);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(updateUrl)).timeout(Duration.ofSeconds(15L)).GET().build();
                HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
                ModpackChecker.LOGGER.info("HTTP response status: {}", (Object)response.statusCode());
                ModpackChecker.LOGGER.info("HTTP response body: {}", (Object)response.body());
                if (response.statusCode() == 200) {
                    UpdateChecker.parseAndCheckVersion(response.body());
                } else {
                    ModpackChecker.LOGGER.error("Failed to check for updates. HTTP Status: {}", (Object)response.statusCode());
                }
            }
            catch (IOException | InterruptedException e) {
                ModpackChecker.LOGGER.error("Error checking for updates", (Throwable)e);
            }
        });
    }

    private static void parseAndCheckVersion(String json) {
        try {
            ModpackChecker.LOGGER.info("Parsing JSON response: {}", (Object)json);
            JsonArray updateArray = (JsonArray)GSON.fromJson(json, JsonArray.class);
            String currentMinecraftVersion = class_310.method_1551().method_1515();
            JsonObject updateInfo = null;
            for (int i = 0; i < updateArray.size(); ++i) {
                JsonObject obj = updateArray.get(i).getAsJsonObject();
                if (!obj.has("version-minecraft")) continue;
                String requiredMinecraftVersion = obj.get("version-minecraft").getAsString();
                ModpackChecker.LOGGER.info("Checking version: {}, Current: {}", (Object)requiredMinecraftVersion, (Object)currentMinecraftVersion);
                if (!requiredMinecraftVersion.equals(currentMinecraftVersion)) continue;
                updateInfo = obj;
                break;
            }
            if (!shownMinecraftVersionToast && updateInfo != null && updateInfo.has("new-version-minecraft") && updateInfo.get("new-version-minecraft").getAsBoolean()) {
                String targetMcVersion = updateInfo.has("version-minecraft") ? updateInfo.get("version-minecraft").getAsString() : currentMinecraftVersion;
                String line1 = updateInfo.has("line-text-1") ? updateInfo.get("line-text-1").getAsString() : "New Minecraft version available!";
                String line2 = updateInfo.has("line-text-2") ? updateInfo.get("line-text-2").getAsString() : "Version: " + targetMcVersion;
                ModpackChecker.LOGGER.info("About to show toast for current MC version: line1='{}', line2='{}'", (Object)line1, (Object)line2);
                class_310.method_1551().execute(() -> {
                    ModpackChecker.LOGGER.info("Executing toast show on main thread");
                    MinecraftVersionToast.show(class_310.method_1551(), line1, line2);
                });
                shownMinecraftVersionToast = true;
                ModpackChecker.LOGGER.info("Shown Minecraft version toast for current version: {} / {} (current {}, target {})", new Object[]{line1, line2, currentMinecraftVersion, targetMcVersion});
            }
            if (updateInfo == null) {
                ModpackChecker.LOGGER.info("No compatible version found for Minecraft {}", (Object)currentMinecraftVersion);
                return;
            }
            String latestVersion = updateInfo.get("version").getAsString();
            String downloadUrl = updateInfo.get("download").getAsString();
            String changelog = updateInfo.has("changelog") ? updateInfo.get("changelog").getAsString() : "Update available";
            String currentVersion = ModpackConfig.getLocalVersion();
            ModpackChecker.LOGGER.info("Current version: {}, Latest version: {}", (Object)currentVersion, (Object)latestVersion);
            if (!latestVersion.equals(currentVersion)) {
                ModpackChecker.LOGGER.info("Update available! Current: {}, Latest: {}", (Object)currentVersion, (Object)latestVersion);
                class_310.method_1551().execute(() -> UpdateChecker.showUpdateNotification(latestVersion, downloadUrl, changelog));
            } else {
                ModpackChecker.LOGGER.info("Modpack is up to date! Version: {}", (Object)currentVersion);
            }
        }
        catch (Exception e) {
            ModpackChecker.LOGGER.error("Error parsing update information", (Throwable)e);
        }
    }

    private static void showUpdateNotification(String version, String downloadUrl, String changelog) {
        class_310 client = class_310.method_1551();
        lastDownloadUrl = downloadUrl;
        pendingVersion = version;
        pendingDownloadUrl = downloadUrl;
        pendingChangelog = changelog;
        ModpackChecker.LOGGER.info("Update notification shown for version: {}", (Object)version);
        ModpackChecker.LOGGER.info("Download URL: {}", (Object)downloadUrl);
        ModpackChecker.LOGGER.info("Changelog: {}", (Object)changelog);
        if (ModpackConfig.shouldShowFullscreenNotification()) {
            client.execute(() -> {
                class_437 currentScreen = client.field_1755;
                UpdateScreen updateScreen = new UpdateScreen(currentScreen, version, downloadUrl, changelog);
                client.method_1507((class_437)updateScreen);
                ModpackChecker.LOGGER.info("Opened full-screen update notification");
            });
        }
        if (client.field_1724 != null && ModpackConfig.shouldShowChatNotification()) {
            UpdateChecker.sendUpdateMessageToChat(client, version, downloadUrl, changelog);
        }
    }

    public static boolean hasPendingUpdate() {
        return pendingVersion != null;
    }

    public static void sendPendingChatMessage() {
        if (UpdateChecker.hasPendingUpdate() && ModpackConfig.shouldShowChatNotification()) {
            class_310 client = class_310.method_1551();
            UpdateChecker.sendUpdateMessageToChat(client, pendingVersion, pendingDownloadUrl, pendingChangelog);
        }
    }

    private static void sendUpdateMessageToChat(class_310 client, String version, String downloadUrl, String changelog) {
        if (client.field_1724 != null) {
            ModpackChecker.LOGGER.info("Sending update message to chat");
            client.execute(() -> {
                try {
                    Thread.sleep(2000L);
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)""), false);
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a76\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"), false);
                    if (ModpackConfig.isCustomChatMessagesEnabled()) {
                        String chatTitle = ModpackConfig.getChatTitle();
                        String versionText = ModpackConfig.getChatVersionText().replace("%current%", ModpackConfig.getLocalVersion()).replace("%latest%", version);
                        String changesText = ModpackConfig.getChatChangesText().replace("%changelog%", changelog);
                        String downloadText = ModpackConfig.getChatDownloadText();
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)chatTitle), false);
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)versionText), false);
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)changesText), false);
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)downloadText), false);
                    } else {
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7eModpack update available!"), false);
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a77Version: \u00a7f" + ModpackConfig.getLocalVersion() + " \u00a77\u2192 \u00a7a" + version)), false);
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a77Changes: \u00a7f" + changelog)), false);
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a77Download:"), false);
                    }
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)downloadUrl), false);
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a76\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"), false);
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)""), false);
                    ModpackChecker.LOGGER.info("Update message sent to chat successfully");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    ModpackChecker.LOGGER.error("Chat message thread interrupted", (Throwable)e);
                }
            });
        } else {
            ModpackChecker.LOGGER.warn("Cannot send chat message - player is null");
        }
    }

    public static void openDownloadUrl() {
        if (lastDownloadUrl != null) {
            try {
                class_156.method_668().method_670(lastDownloadUrl);
                ModpackChecker.LOGGER.info("Opened download URL: {}", (Object)lastDownloadUrl);
            }
            catch (Exception e) {
                ModpackChecker.LOGGER.error("Failed to open download URL", (Throwable)e);
            }
        } else {
            ModpackChecker.LOGGER.warn("No download URL available");
        }
    }
}

