/*
 * Decompiled with CFR 0.152.
 */
package com.stromblex.modpackchecker;

import com.stromblex.modpackchecker.ModpackChecker;
import com.stromblex.modpackchecker.ModpackConfig;
import com.stromblex.modpackchecker.UpdateChecker;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;

@Environment(value=EnvType.CLIENT)
public class ModpackCheckerClient
implements ClientModInitializer {
    private boolean hasCheckedForUpdates = false;
    private boolean shouldShowChatMessage = false;
    private int tickCounter = 0;

    public void onInitializeClient() {
        ModpackChecker.LOGGER.info("Modpack Checker Client initialized!");
        ModpackConfig.init();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            ++this.tickCounter;
            if (!this.hasCheckedForUpdates && this.tickCounter > 1) {
                this.hasCheckedForUpdates = true;
                ModpackChecker.LOGGER.info("Checking for updates on startup...");
                UpdateChecker.checkForUpdates();
            }
            if (this.shouldShowChatMessage && client.field_1724 != null) {
                this.shouldShowChatMessage = false;
                UpdateChecker.sendPendingChatMessage();
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (UpdateChecker.hasPendingUpdate()) {
                this.shouldShowChatMessage = true;
                ModpackChecker.LOGGER.info("Player joined world, will show update message in chat (every time)");
            }
        });
    }
}

