/*
 * Decompiled with CFR 0.152.
 */
package com.stromblex.modpackchecker;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stromblex.modpackchecker.ModpackChecker;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ModpackConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_NAME = "modpack-checker.json";
    private static Path configPath;
    private static JsonObject config;

    public static void init() {
        configPath = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE_NAME);
        ModpackConfig.loadConfig();
    }

    private static void loadConfig() {
        try {
            if (Files.exists(configPath, new LinkOption[0])) {
                String content = Files.readString(configPath);
                config = (JsonObject)GSON.fromJson(content, JsonObject.class);
                ModpackChecker.LOGGER.info("Config loaded from: {}", (Object)configPath);
                ModpackConfig.updateConfigWithMissingElements();
            } else {
                ModpackConfig.createDefaultConfig();
            }
        }
        catch (IOException e) {
            ModpackChecker.LOGGER.error("Failed to load config", (Throwable)e);
            ModpackConfig.createDefaultConfig();
        }
    }

    private static void updateConfigWithMissingElements() {
        boolean updated = false;
        if (!config.has("updateUrl")) {
            config.addProperty("updateUrl", "https://your-website.com/modpack-update.json");
            updated = true;
            ModpackChecker.LOGGER.info("Added missing updateUrl to config");
        }
        if (!config.has("checkOnStartup")) {
            config.addProperty("checkOnStartup", Boolean.valueOf(true));
            updated = true;
            ModpackChecker.LOGGER.info("Added missing checkOnStartup to config");
        }
        if (!config.has("localVersion")) {
            config.addProperty("localVersion", ModpackConfig.resolveCurrentVersion());
            updated = true;
            ModpackChecker.LOGGER.info("Added missing localVersion to config");
        }
        if (!config.has("showFullscreenNotification")) {
            config.addProperty("showFullscreenNotification", Boolean.valueOf(true));
            updated = true;
            ModpackChecker.LOGGER.info("Added missing showFullscreenNotification to config");
        }
        if (!config.has("showChatNotification")) {
            config.addProperty("showChatNotification", Boolean.valueOf(true));
            updated = true;
            ModpackChecker.LOGGER.info("Added missing showChatNotification to config");
        }
        if (!config.has("chatTitle")) {
            config.addProperty("chatTitle", "\u00a7eModpack update available!");
            updated = true;
            ModpackChecker.LOGGER.info("Added missing chatTitle to config");
        }
        if (!config.has("chatVersionText")) {
            config.addProperty("chatVersionText", "\u00a77Version: \u00a7f%current% \u00a77\u2192 \u00a7a%latest%");
            updated = true;
            ModpackChecker.LOGGER.info("Added missing chatVersionText to config");
        }
        if (!config.has("chatChangesText")) {
            config.addProperty("chatChangesText", "\u00a77Changes: \u00a7f%changelog%");
            updated = true;
            ModpackChecker.LOGGER.info("Added missing chatChangesText to config");
        }
        if (!config.has("chatDownloadText")) {
            config.addProperty("chatDownloadText", "\u00a77Download:");
            updated = true;
            ModpackChecker.LOGGER.info("Added missing chatDownloadText to config");
        }
        if (!config.has("enableCustomChatMessages")) {
            config.addProperty("enableCustomChatMessages", Boolean.valueOf(true));
            updated = true;
            ModpackChecker.LOGGER.info("Added missing enableCustomChatMessages to config");
        }
        if (!config.has("notificationDelay")) {
            config.addProperty("notificationDelay", (Number)3000);
            updated = true;
            ModpackChecker.LOGGER.info("Added missing notificationDelay to config");
        }
        if (!config.has("fullscreenTitle")) {
            config.addProperty("fullscreenTitle", "Update Available");
            updated = true;
            ModpackChecker.LOGGER.info("Added missing fullscreenTitle to config");
        }
        if (!config.has("fullscreenVersionText")) {
            config.addProperty("fullscreenVersionText", "Current: %current% \u2192 Latest: %latest%");
            updated = true;
            ModpackChecker.LOGGER.info("Added missing fullscreenVersionText to config");
        }
        if (!config.has("enableCustomFullscreenMessages")) {
            config.addProperty("enableCustomFullscreenMessages", Boolean.valueOf(true));
            updated = true;
            ModpackChecker.LOGGER.info("Added missing enableCustomFullscreenMessages to config");
        }
        if (!config.has("closeGameAfterDownload")) {
            config.addProperty("closeGameAfterDownload", Boolean.valueOf(true));
            updated = true;
            ModpackChecker.LOGGER.info("Added missing closeGameAfterDownload to config");
        }
        if (updated) {
            ModpackConfig.saveConfig();
            ModpackChecker.LOGGER.info("Config updated with missing elements");
        }
    }

    private static void createDefaultConfig() {
        config = new JsonObject();
        config.addProperty("updateUrl", "https://your-website.com/modpack-update.json");
        config.addProperty("checkOnStartup", Boolean.valueOf(true));
        config.addProperty("localVersion", ModpackConfig.resolveCurrentVersion());
        config.addProperty("showFullscreenNotification", Boolean.valueOf(true));
        config.addProperty("showChatNotification", Boolean.valueOf(true));
        config.addProperty("chatTitle", "\u00a7eModpack update available!");
        config.addProperty("chatVersionText", "\u00a77Version: \u00a7f%current% \u00a77\u2192 \u00a7a%latest%");
        config.addProperty("chatChangesText", "\u00a77Changes: \u00a7f%changelog%");
        config.addProperty("chatDownloadText", "\u00a77Download:");
        config.addProperty("enableCustomChatMessages", Boolean.valueOf(true));
        config.addProperty("notificationDelay", (Number)3000);
        config.addProperty("fullscreenTitle", "Update Available");
        config.addProperty("fullscreenVersionText", "Current: %current% \u2192 Latest: %latest%");
        config.addProperty("enableCustomFullscreenMessages", Boolean.valueOf(true));
        config.addProperty("closeGameAfterDownload", Boolean.valueOf(true));
        ModpackConfig.saveConfig();
        ModpackChecker.LOGGER.info("Created default config at: {}", (Object)configPath);
    }

    private static void saveConfig() {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            Files.writeString(configPath, (CharSequence)GSON.toJson((JsonElement)config), new OpenOption[0]);
        }
        catch (IOException e) {
            ModpackChecker.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static String getUpdateUrl() {
        if (config != null && config.has("updateUrl")) {
            return config.get("updateUrl").getAsString();
        }
        return null;
    }

    public static boolean shouldCheckOnStartup() {
        if (config != null && config.has("checkOnStartup")) {
            return config.get("checkOnStartup").getAsBoolean();
        }
        return true;
    }

    public static String getLocalVersion() {
        if (config != null && config.has("localVersion")) {
            return config.get("localVersion").getAsString();
        }
        return ModpackConfig.resolveCurrentVersion();
    }

    public static void setUpdateUrl(String url) {
        if (config != null) {
            config.addProperty("updateUrl", url);
            ModpackConfig.saveConfig();
        }
    }

    public static void setCheckOnStartup(boolean check) {
        if (config != null) {
            config.addProperty("checkOnStartup", Boolean.valueOf(check));
            ModpackConfig.saveConfig();
        }
    }

    public static boolean shouldShowFullscreenNotification() {
        if (config != null && config.has("showFullscreenNotification")) {
            return config.get("showFullscreenNotification").getAsBoolean();
        }
        return true;
    }

    public static boolean shouldShowChatNotification() {
        if (config != null && config.has("showChatNotification")) {
            return config.get("showChatNotification").getAsBoolean();
        }
        return true;
    }

    public static String getChatTitle() {
        if (config != null && config.has("chatTitle")) {
            return config.get("chatTitle").getAsString();
        }
        return "\u00a7eModpack update available!";
    }

    public static String getChatVersionText() {
        if (config != null && config.has("chatVersionText")) {
            return config.get("chatVersionText").getAsString();
        }
        return "\u00a77Version: \u00a7f%current% \u00a77\u2192 \u00a7a%latest%";
    }

    public static String getChatChangesText() {
        if (config != null && config.has("chatChangesText")) {
            return config.get("chatChangesText").getAsString();
        }
        return "\u00a77Changes: \u00a7f%changelog%";
    }

    public static String getChatDownloadText() {
        if (config != null && config.has("chatDownloadText")) {
            return config.get("chatDownloadText").getAsString();
        }
        return "\u00a77Download:";
    }

    public static boolean isCustomChatMessagesEnabled() {
        if (config != null && config.has("enableCustomChatMessages")) {
            return config.get("enableCustomChatMessages").getAsBoolean();
        }
        return true;
    }

    public static int getNotificationDelay() {
        if (config != null && config.has("notificationDelay")) {
            return config.get("notificationDelay").getAsInt();
        }
        return 3000;
    }

    public static void setShowFullscreenNotification(boolean show) {
        if (config != null) {
            config.addProperty("showFullscreenNotification", Boolean.valueOf(show));
            ModpackConfig.saveConfig();
        }
    }

    public static void setShowChatNotification(boolean show) {
        if (config != null) {
            config.addProperty("showChatNotification", Boolean.valueOf(show));
            ModpackConfig.saveConfig();
        }
    }

    public static void setChatTitle(String title) {
        if (config != null) {
            config.addProperty("chatTitle", title);
            ModpackConfig.saveConfig();
        }
    }

    public static void setNotificationDelay(int delay) {
        if (config != null) {
            config.addProperty("notificationDelay", (Number)delay);
            ModpackConfig.saveConfig();
        }
    }

    public static String getFullscreenTitle() {
        if (config != null && config.has("fullscreenTitle")) {
            return config.get("fullscreenTitle").getAsString();
        }
        return "Update Available";
    }

    public static String getFullscreenVersionText() {
        if (config != null && config.has("fullscreenVersionText")) {
            return config.get("fullscreenVersionText").getAsString();
        }
        return "Current: %current% \u2192 Latest: %latest%";
    }

    public static boolean isCustomFullscreenMessagesEnabled() {
        if (config != null && config.has("enableCustomFullscreenMessages")) {
            return config.get("enableCustomFullscreenMessages").getAsBoolean();
        }
        return true;
    }

    public static boolean shouldCloseGameAfterDownload() {
        if (config != null && config.has("closeGameAfterDownload")) {
            return config.get("closeGameAfterDownload").getAsBoolean();
        }
        return true;
    }

    public static void setFullscreenTitle(String title) {
        if (config != null) {
            config.addProperty("fullscreenTitle", title);
            ModpackConfig.saveConfig();
        }
    }

    public static void setCloseGameAfterDownload(boolean close) {
        if (config != null) {
            config.addProperty("closeGameAfterDownload", Boolean.valueOf(close));
            ModpackConfig.saveConfig();
        }
    }

    private static String resolveCurrentVersion() {
        return FabricLoader.getInstance().getModContainer("modpack-checker").map(c -> c.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
    }
}

