/*
 * Decompiled with CFR 0.152.
 */
package com.stromblex.modpackchecker;

import com.stromblex.modpackchecker.ModpackChecker;
import com.stromblex.modpackchecker.ModpackConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class UpdateScreen
extends class_437 {
    private final class_437 parent;
    private final String version;
    private final String downloadUrl;
    private final String changelog;

    public UpdateScreen(class_437 parent, String version, String downloadUrl, String changelog) {
        super((class_2561)class_2561.method_43470((String)"Modpack Update"));
        this.parent = parent;
        this.version = version;
        this.downloadUrl = downloadUrl;
        this.changelog = changelog;
    }

    protected void method_25426() {
        super.method_25426();
        int boxWidth = 450;
        int boxHeight = 220;
        int boxX = (this.field_22789 - boxWidth) / 2;
        int boxY = (this.field_22790 - boxHeight) / 2;
        int buttonWidth = 110;
        int buttonHeight = 28;
        int spacing = 12;
        int totalWidth = buttonWidth * 2 + spacing;
        int startX = boxX + (boxWidth - totalWidth) / 2;
        int buttonY = boxY + boxHeight - 40;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Download"), button -> {
            try {
                class_156.method_668().method_670(this.downloadUrl);
                ModpackChecker.LOGGER.info("Opening download URL: {}", (Object)this.downloadUrl);
                if (ModpackConfig.shouldCloseGameAfterDownload()) {
                    ModpackChecker.LOGGER.info("Closing game after download as configured");
                    if (this.field_22787 != null) {
                        this.field_22787.method_1592();
                    }
                } else {
                    this.method_25419();
                }
            }
            catch (Exception e) {
                ModpackChecker.LOGGER.error("Failed to open download URL", (Throwable)e);
            }
        }).method_46434(startX, buttonY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Skip"), button -> {
            ModpackChecker.LOGGER.info("User chose to skip update");
            this.method_25419();
        }).method_46434(startX + buttonWidth + spacing, buttonY, buttonWidth, buttonHeight).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -436141047);
        int boxWidth = 450;
        int boxHeight = 220;
        int boxX = (this.field_22789 - boxWidth) / 2;
        int boxY = (this.field_22790 - boxHeight) / 2;
        context.method_25294(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -15920873);
        context.method_25294(boxX - 1, boxY - 1, boxX + boxWidth + 1, boxY + boxHeight + 1, -14604755);
        context.method_25294(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -15920873);
        context.method_25294(boxX, boxY, boxX + boxWidth, boxY + 50, -15328478);
        context.method_25294(boxX, boxY + 50, boxX + boxWidth, boxY + 51, -14604755);
        int headerCenterY = boxY + 25;
        if (ModpackConfig.isCustomFullscreenMessagesEnabled()) {
            title = ModpackConfig.getFullscreenTitle();
            context.method_51433(this.field_22793, title, boxX + 20, headerCenterY - 4, -985348, false);
        } else {
            title = "Update Available";
            context.method_51433(this.field_22793, title, boxX + 20, headerCenterY - 4, -985348, false);
        }
        String versionBadge = "v" + this.version;
        int badgeWidth = this.field_22793.method_1727(versionBadge) + 10;
        int badgeX = boxX + boxWidth - badgeWidth - 15;
        int badgeY = headerCenterY - 6;
        context.method_25294(badgeX - 5, badgeY - 2, badgeX + badgeWidth - 5, badgeY + 12, -14449098);
        context.method_51433(this.field_22793, versionBadge, badgeX, badgeY + 2, -1, false);
        String currentVersionText = "Current: v" + ModpackConfig.getLocalVersion();
        context.method_51433(this.field_22793, currentVersionText, boxX + 20, boxY + 70, -7629666, false);
        String newVersionText = "Latest: v" + this.version;
        context.method_51433(this.field_22793, newVersionText, boxX + 20, boxY + 85, -10967297, false);
        context.method_25294(boxX + 20, boxY + 105, boxX + boxWidth - 20, boxY + 106, -14604755);
        context.method_51433(this.field_22793, "What's Changed:", boxX + 20, boxY + 120, -985348, false);
        String changelogPrefix = "\u2022 ";
        String changelogText = this.changelog.length() > 50 ? this.changelog.substring(0, 47) + "..." : this.changelog;
        context.method_51433(this.field_22793, changelogPrefix, boxX + 20, boxY + 140, -10967297, false);
        context.method_51433(this.field_22793, changelogText, boxX + 30, boxY + 140, -7629666, false);
        int buttonWidth = 110;
        int buttonHeight = 28;
        int spacing = 12;
        int totalWidth = buttonWidth * 2 + spacing;
        int startX = boxX + (boxWidth - totalWidth) / 2;
        int buttonY = boxY + boxHeight - 40;
        context.method_25294(startX, buttonY, startX + buttonWidth, buttonY + buttonHeight, -13721533);
        int skipButtonX = startX + buttonWidth + spacing;
        context.method_25294(skipButtonX, buttonY, skipButtonX + buttonWidth, buttonY + buttonHeight, -13617603);
        context.method_25294(boxX + 20, boxY + 165, boxX + boxWidth - 20, boxY + 166, -14604755);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25422() {
        return false;
    }
}

