/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import java.util.Map;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Visibilities {
    private static final Map<Visibility, Integer> ORDERED_VISIBILITIES;
    private static final Public DEFAULT_VISIBILITY;
    @NotNull
    public static final Visibilities INSTANCE;

    @Nullable
    public final Integer compareLocal$compiler_common(@NotNull Visibility first2, @NotNull Visibility second2) {
        Intrinsics.checkNotNullParameter(first2, "first");
        Intrinsics.checkNotNullParameter(second2, "second");
        if (first2 == second2) {
            return 0;
        }
        Integer firstIndex = ORDERED_VISIBILITIES.get(first2);
        Integer secondIndex = ORDERED_VISIBILITIES.get(second2);
        return firstIndex == null || secondIndex == null || Intrinsics.areEqual(firstIndex, secondIndex) ? null : Integer.valueOf(firstIndex - secondIndex);
    }

    public final boolean isPrivate(@NotNull Visibility visibility) {
        Intrinsics.checkNotNullParameter(visibility, "visibility");
        return visibility == Private.INSTANCE || visibility == PrivateToThis.INSTANCE;
    }

    private Visibilities() {
    }

    static {
        Visibilities visibilities;
        INSTANCE = visibilities = new Visibilities();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        Map<Visibility, Integer> map2 = MapsKt.createMapBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        Map<Visibility, Integer> $this$buildMap = map2;
        boolean bl5 = false;
        $this$buildMap.put(PrivateToThis.INSTANCE, 0);
        $this$buildMap.put(Private.INSTANCE, 0);
        $this$buildMap.put(Internal.INSTANCE, 1);
        $this$buildMap.put(Protected.INSTANCE, 1);
        $this$buildMap.put(Public.INSTANCE, 2);
        ORDERED_VISIBILITIES = MapsKt.build(map2);
        DEFAULT_VISIBILITY = Public.INSTANCE;
    }

    public static final class Private
    extends Visibility {
        @NotNull
        public static final Private INSTANCE;

        private Private() {
            super("private", false);
        }

        static {
            Private private_;
            INSTANCE = private_ = new Private();
        }
    }

    public static final class PrivateToThis
    extends Visibility {
        @NotNull
        public static final PrivateToThis INSTANCE;

        @Override
        @NotNull
        public String getInternalDisplayName() {
            return "private/*private to this*/";
        }

        private PrivateToThis() {
            super("private_to_this", false);
        }

        static {
            PrivateToThis privateToThis;
            INSTANCE = privateToThis = new PrivateToThis();
        }
    }

    public static final class Protected
    extends Visibility {
        @NotNull
        public static final Protected INSTANCE;

        private Protected() {
            super("protected", true);
        }

        static {
            Protected protected_;
            INSTANCE = protected_ = new Protected();
        }
    }

    public static final class Internal
    extends Visibility {
        @NotNull
        public static final Internal INSTANCE;

        private Internal() {
            super("internal", false);
        }

        static {
            Internal internal;
            INSTANCE = internal = new Internal();
        }
    }

    public static final class Public
    extends Visibility {
        @NotNull
        public static final Public INSTANCE;

        private Public() {
            super("public", true);
        }

        static {
            Public public_;
            INSTANCE = public_ = new Public();
        }
    }

    public static final class Local
    extends Visibility {
        @NotNull
        public static final Local INSTANCE;

        private Local() {
            super("local", false);
        }

        static {
            Local local;
            INSTANCE = local = new Local();
        }
    }

    public static final class Inherited
    extends Visibility {
        @NotNull
        public static final Inherited INSTANCE;

        private Inherited() {
            super("inherited", false);
        }

        static {
            Inherited inherited;
            INSTANCE = inherited = new Inherited();
        }
    }

    public static final class InvisibleFake
    extends Visibility {
        @NotNull
        public static final InvisibleFake INSTANCE;

        private InvisibleFake() {
            super("invisible_fake", false);
        }

        static {
            InvisibleFake invisibleFake;
            INSTANCE = invisibleFake = new InvisibleFake();
        }
    }

    public static final class Unknown
    extends Visibility {
        @NotNull
        public static final Unknown INSTANCE;

        private Unknown() {
            super("unknown", false);
        }

        static {
            Unknown unknown;
            INSTANCE = unknown = new Unknown();
        }
    }
}

