/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.cmd;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Map;
import net.kyori.adventure.text.minimessage.MiniMessage;
import off.szymon.vMessage.VMessagePlugin;
import off.szymon.vMessage.cmd.ReplyCommand;
import off.szymon.vMessage.compatibility.LuckPermsCompatibilityProvider;
import off.szymon.vMessage.config.ConfigManager;

public class MessageCommand {
    private final LuckPermsCompatibilityProvider lp = VMessagePlugin.get().getLuckPermsCompatibilityProvider();

    public BrigadierCommand createCommand() {
        return new BrigadierCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"message").requires(src -> src.hasPermission("vmessage.command.message"))).then(RequiredArgumentBuilder.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (Player player : VMessagePlugin.get().getServer().getAllPlayers()) {
                builder.suggest(player.getUsername());
            }
            return builder.buildFuture();
        }).then(RequiredArgumentBuilder.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            Player receiver;
            String senderFormat = ConfigManager.get().getConfig().getCommands().getMessage().getFormat().getSender();
            String receiverFormat = ConfigManager.get().getConfig().getCommands().getMessage().getFormat().getReceiver();
            CommandSource sender = (CommandSource)ctx.getSource();
            Player senderPlayer = ctx.getSource() instanceof Player ? (Player)ctx.getSource() : null;
            try {
                receiver = (Player)VMessagePlugin.get().getServer().getPlayer(StringArgumentType.getString((CommandContext)ctx, (String)"player")).orElseThrow();
            }
            catch (Exception e) {
                sender.sendRichMessage("<red>Player not found!");
                return 1;
            }
            if (senderPlayer != null && senderPlayer.getUniqueId().equals(receiver.getUniqueId())) {
                sender.sendRichMessage("<red>You cannot message yourself!");
                return 1;
            }
            String message = StringArgumentType.getString((CommandContext)ctx, (String)"message");
            if (!ConfigManager.get().getConfig().getCommands().getMessage().getAllowMiniMessage()) {
                message = MiniMessage.miniMessage().escapeTags(message);
            }
            if (senderPlayer != null) {
                String senderServer = senderPlayer.getCurrentServer().map(server -> VMessagePlugin.get().getBroadcaster().parseAlias(server.getServerInfo().getName())).orElse("Unknown");
                String receiverServer = receiver.getCurrentServer().map(server -> VMessagePlugin.get().getBroadcaster().parseAlias(server.getServerInfo().getName())).orElse("Unknown");
                senderFormat = senderFormat.replace("%sender%", senderPlayer.getUsername()).replace("%sender-server%", senderServer).replace("%receiver-server%", receiverServer);
                receiverFormat = receiverFormat.replace("%sender%", senderPlayer.getUsername()).replace("%sender-server%", senderServer).replace("%receiver-server%", receiverServer);
            } else {
                senderFormat = senderFormat.replace("%sender%", "Console").replace("%sender-server%", "Console");
                receiverFormat = receiverFormat.replace("%sender%", "Console").replace("%sender-server%", "Console");
            }
            senderFormat = senderFormat.replace("%receiver%", receiver.getUsername()).replace("%message%", message);
            receiverFormat = receiverFormat.replace("%receiver%", receiver.getUsername()).replace("%message%", message);
            if (this.lp != null) {
                LuckPermsCompatibilityProvider.PlayerData receiverData;
                if (senderPlayer != null) {
                    LuckPermsCompatibilityProvider.PlayerData senderData = this.lp.getMetaData(senderPlayer);
                    senderFormat = senderFormat.replace("%sender-prefix%", senderData.metaData().getPrefix() != null ? senderData.metaData().getPrefix() : "").replace("%sender-suffix%", senderData.metaData().getSuffix() != null ? senderData.metaData().getSuffix() : "");
                    for (Map.Entry<String, String> entry : VMessagePlugin.get().getBroadcaster().getMetaPlaceholders().entrySet()) {
                        senderFormat = senderFormat.replace(entry.getKey(), senderData.metaData().getMetaValue(entry.getValue()) != null ? senderData.metaData().getMetaValue(entry.getValue()) : "");
                    }
                } else {
                    senderFormat = senderFormat.replace("%sender-prefix%", "").replace("%sender-suffix%", "");
                }
                senderFormat = senderFormat.replace("%receiver-prefix%", (receiverData = this.lp.getMetaData(receiver)).metaData().getPrefix() != null ? receiverData.metaData().getPrefix() : "").replace("%receiver-suffix%", receiverData.metaData().getSuffix() != null ? receiverData.metaData().getSuffix() : "");
                receiverFormat = receiverFormat.replace("%receiver-prefix%", receiverData.metaData().getPrefix() != null ? receiverData.metaData().getPrefix() : "").replace("%receiver-suffix%", receiverData.metaData().getSuffix() != null ? receiverData.metaData().getSuffix() : "");
                for (Map.Entry<String, String> entry : VMessagePlugin.get().getBroadcaster().getMetaPlaceholders().entrySet()) {
                    senderFormat = senderFormat.replace(entry.getKey(), receiverData.metaData().getMetaValue(entry.getValue()) != null ? receiverData.metaData().getMetaValue(entry.getValue()) : "");
                    receiverFormat = receiverFormat.replace(entry.getKey(), receiverData.metaData().getMetaValue(entry.getValue()) != null ? receiverData.metaData().getMetaValue(entry.getValue()) : "");
                }
            } else {
                senderFormat = senderFormat.replace("%sender-prefix%", "").replace("%sender-suffix%", "").replace("%receiver-prefix%", "").replace("%receiver-suffix%", "");
            }
            sender.sendRichMessage(senderFormat);
            receiver.sendRichMessage(receiverFormat);
            if (senderPlayer != null) {
                ReplyCommand.messageSent(senderPlayer.getUniqueId(), receiver.getUniqueId());
            }
            return 1;
        }))));
    }
}

