/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.config;

import com.google.common.io.Files;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import off.szymon.vMessage.VMessagePlugin;
import off.szymon.vMessage.config.tree.MainConfig;
import off.szymon.vMessage.libs.configurate.CommentedConfigurationNode;
import off.szymon.vMessage.libs.configurate.ConfigurationNode;
import off.szymon.vMessage.libs.configurate.ConfigurationOptions;
import off.szymon.vMessage.libs.configurate.loader.HeaderMode;
import off.szymon.vMessage.libs.configurate.yaml.NodeStyle;
import off.szymon.vMessage.libs.configurate.yaml.YamlConfigurationLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Loff/szymon/vMessage/config/ConfigManager;", "", "<init>", "()V", "fileName", "", "path", "Ljava/nio/file/Path;", "file", "Ljava/io/File;", "loader", "Loff/szymon/vMessage/libs/configurate/yaml/YamlConfigurationLoader;", "value", "Loff/szymon/vMessage/config/tree/MainConfig;", "config", "getConfig", "()Loff/szymon/vMessage/config/tree/MainConfig;", "root", "Loff/szymon/vMessage/libs/configurate/CommentedConfigurationNode;", "load", "", "save", "getNode", "Companion", "vMessage"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\noff/szymon/vMessage/config/ConfigManager\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,94:1\n37#2:95\n36#2,3:96\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\noff/szymon/vMessage/config/ConfigManager\n*L\n93#1:95\n93#1:96,3\n*E\n"})
public final class ConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fileName;
    @NotNull
    private final Path path;
    @NotNull
    private final File file;
    @NotNull
    private final YamlConfigurationLoader loader;
    private MainConfig config;
    private CommentedConfigurationNode root;
    private static ConfigManager instance;

    public ConfigManager() {
        this.fileName = "config.yml";
        Path path = VMessagePlugin.get().getDataFolder().toPath().resolve(this.fileName);
        Intrinsics.checkNotNullExpressionValue(path, "resolve(...)");
        this.path = path;
        File file = this.path.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
        this.file = file;
        YamlConfigurationLoader yamlConfigurationLoader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(this.path)).defaultOptions(ConfigManager::loader$lambda$0)).indent(2).nodeStyle(NodeStyle.BLOCK).headerMode(HeaderMode.PRESERVE)).build();
        Intrinsics.checkNotNullExpressionValue(yamlConfigurationLoader, "build(...)");
        this.loader = yamlConfigurationLoader;
        instance = this;
        this.load();
    }

    @NotNull
    public final MainConfig getConfig() {
        MainConfig mainConfig = this.config;
        if (mainConfig != null) {
            return mainConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException("config");
        return null;
    }

    public final void load() {
        MainConfig mainConfig;
        Object n = this.loader.load();
        Intrinsics.checkNotNullExpressionValue(n, "load(...)");
        this.root = (CommentedConfigurationNode)n;
        CommentedConfigurationNode commentedConfigurationNode = this.root;
        if (commentedConfigurationNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException("root");
            commentedConfigurationNode = null;
        }
        if ((mainConfig = commentedConfigurationNode.get(MainConfig.class)) == null) {
            mainConfig = this.config = new MainConfig();
        }
        if (this.getConfig().getBackupConfig()) {
            Files.copy((File)this.file, (File)new File(this.file.getParentFile(), this.fileName + ".bak"));
        }
        this.getConfig().setBackupConfig(false);
        this.save();
    }

    public final void save() {
        CommentedConfigurationNode commentedConfigurationNode = this.root;
        if (commentedConfigurationNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException("root");
            commentedConfigurationNode = null;
        }
        commentedConfigurationNode.set(MainConfig.class, (Object)this.getConfig());
        CommentedConfigurationNode commentedConfigurationNode2 = this.root;
        if (commentedConfigurationNode2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("root");
            commentedConfigurationNode2 = null;
        }
        this.loader.save(commentedConfigurationNode2);
    }

    @NotNull
    public final CommentedConfigurationNode getNode(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        CommentedConfigurationNode commentedConfigurationNode = this.root;
        if (commentedConfigurationNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException("root");
            commentedConfigurationNode = null;
        }
        char[] cArray = new char[]{'.'};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)path, cArray, false, 0, 6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        ConfigurationNode configurationNode = commentedConfigurationNode.node(Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue(configurationNode, "node(...)");
        return (CommentedConfigurationNode)configurationNode;
    }

    private static final ConfigurationOptions loader$lambda$0(ConfigurationOptions opts) {
        return opts.shouldCopyDefaults(true).header("vMessage Configuration File\nThanks for downloading my plugin! I hope you like it!\nMiniMessage is supported for formatting in all messages.\nPlaceholders are parsed before MiniMessage so you can use them in your format.\nFor in-depth explanation of the configuration options, visit: https://github.com/szymon-off/vMessage/wiki/Configuration-(config.yml)\n\n\u26a0\ufe0f If you have used vMessage before v1.8.0, the contents of this file may be malformed \u26a0\ufe0f").implicitInitialization(true);
    }

    @JvmStatic
    @NotNull
    public static final ConfigManager get() {
        return Companion.get();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0005H\u0007R\u0018\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083.\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\b"}, d2={"Loff/szymon/vMessage/config/ConfigManager$Companion;", "", "<init>", "()V", "instance", "Loff/szymon/vMessage/config/ConfigManager;", "getInstance$annotations", "get", "vMessage"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getInstance$annotations() {
        }

        @JvmStatic
        @NotNull
        public final ConfigManager get() {
            ConfigManager configManager = instance;
            if (configManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException("instance");
                configManager = null;
            }
            return configManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

