/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.loader;

import java.util.Locale;
import off.szymon.vMessage.libs.configurate.ConfigurationNode;
import off.szymon.vMessage.libs.configurate.loader.LoaderOptionSource;
import org.checkerframework.checker.nullness.qual.Nullable;

final class LoaderOptionSources {
    static final LoaderOptionSource ENVIRONMENT = new EnvironmentVariables("CONFIGURATE");
    static final LoaderOptionSource SYSTEM_PROPERTIES = new SystemProperties("configurate");

    private LoaderOptionSources() {
    }

    static final class EnvironmentVariables
    implements LoaderOptionSource {
        private static final char ENVIORNMENT_VAR_SEPARATOR = '_';
        private final String prefix;

        EnvironmentVariables(String prefix) {
            this.prefix = prefix.toUpperCase(Locale.ROOT);
        }

        @Override
        public @Nullable String get(String ... path) {
            if (path.length == 0) {
                throw new IllegalArgumentException("A provided path must have at least one element");
            }
            StringBuilder varName = new StringBuilder(this.prefix);
            for (String element : path) {
                varName.append('_').append(element.toUpperCase(Locale.ROOT));
            }
            return System.getenv(varName.toString());
        }
    }

    static final class SystemProperties
    implements LoaderOptionSource {
        private static final char SYSTEM_PROPERTY_SEPARATOR = '.';
        private final String prefix;

        SystemProperties(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public @Nullable String get(String ... path) {
            if (path.length == 0) {
                throw new IllegalArgumentException("A provided path must have at least one element");
            }
            StringBuilder varName = new StringBuilder(this.prefix);
            for (String element : path) {
                varName.append('.').append(element);
            }
            return System.getProperty(varName.toString());
        }
    }

    static final class Composite
    implements LoaderOptionSource {
        private final LoaderOptionSource[] sources;

        Composite(LoaderOptionSource[] sources) {
            this.sources = sources;
        }

        @Override
        public @Nullable String get(String ... path) {
            if (path.length == 0) {
                throw new IllegalArgumentException("A provided path must have at least one element");
            }
            for (LoaderOptionSource source : this.sources) {
                @Nullable String result2 = source.get(path);
                if (result2 == null) continue;
                return result2;
            }
            return null;
        }
    }

    static final class Node
    implements LoaderOptionSource {
        private final ConfigurationNode source;

        Node(ConfigurationNode source) {
            this.source = source;
        }

        @Override
        public @Nullable String get(String ... path) {
            if (path.length == 0) {
                throw new IllegalArgumentException("A provided path must have at least one element");
            }
            return this.source.node(path).getString();
        }
    }
}

