/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.reference;

import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.concurrent.Executor;
import off.szymon.vMessage.libs.configurate.ConfigurateException;
import off.szymon.vMessage.libs.configurate.ConfigurationNode;
import off.szymon.vMessage.libs.configurate.ScopedConfigurationNode;
import off.szymon.vMessage.libs.configurate.loader.ConfigurationLoader;
import off.szymon.vMessage.libs.configurate.reactive.Disposable;
import off.szymon.vMessage.libs.configurate.reactive.Subscriber;
import off.szymon.vMessage.libs.configurate.reference.ConfigurationReference;
import off.szymon.vMessage.libs.configurate.reference.ManualConfigurationReference;
import off.szymon.vMessage.libs.configurate.util.UnmodifiableCollections;
import org.checkerframework.checker.nullness.qual.Nullable;

class WatchingConfigurationReference<N extends ScopedConfigurationNode<N>>
extends ManualConfigurationReference<N>
implements Subscriber<WatchEvent<?>> {
    private volatile boolean saveSuppressed;
    private @Nullable Disposable disposable;

    WatchingConfigurationReference(ConfigurationLoader<? extends N> loader, Executor taskExecutor) {
        super(loader, taskExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ConfigurationNode newNode) throws ConfigurateException {
        ConfigurationLoader configurationLoader = this.loader();
        synchronized (configurationLoader) {
            try {
                this.saveSuppressed = true;
                super.save(newNode);
            }
            finally {
                this.saveSuppressed = false;
            }
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.disposable != null) {
            this.disposable.dispose();
            this.disposable = null;
        }
    }

    @Override
    public void submit(WatchEvent<?> item) {
        if (!this.saveSuppressed || item.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.LOADING, e));
            }
        }
    }

    @Override
    public void onError(Throwable thrown) {
        this.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.UNKNOWN, thrown));
    }

    @Override
    public void onClose() {
        this.close();
    }

    void disposable(Disposable disposable) {
        this.disposable = disposable;
    }
}

