/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.serialize;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import off.szymon.vMessage.libs.configurate.serialize.CoercionFailedException;
import off.szymon.vMessage.libs.configurate.serialize.ScalarSerializer;
import off.szymon.vMessage.libs.configurate.serialize.SerializationException;
import org.checkerframework.checker.nullness.qual.NonNull;

final class CharSerializer
extends ScalarSerializer<Character> {
    CharSerializer() {
        super(Character.class);
    }

    @Override
    public Character deserialize(Type type2, Object val) throws SerializationException {
        if (val instanceof String) {
            String strVal = (String)val;
            if (strVal.length() == 1) {
                return Character.valueOf(strVal.charAt(0));
            }
            throw new SerializationException(type2, "Only single character expected, but received " + strVal);
        }
        if (val instanceof Number) {
            return Character.valueOf((char)((Number)val).shortValue());
        }
        throw new CoercionFailedException(type2, val, "char");
    }

    @Override
    public Object serialize(@NonNull Character item, Predicate<Class<?>> typeSupported) {
        if (typeSupported.test(Character.TYPE)) {
            return item;
        }
        return item.toString();
    }
}

