/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.serialize;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import off.szymon.vMessage.libs.configurate.serialize.ScalarSerializer;
import off.szymon.vMessage.libs.configurate.serialize.SerializationException;
import off.szymon.vMessage.libs.configurate.util.EnumLookup;
import org.checkerframework.checker.nullness.qual.Nullable;

final class EnumValueSerializer
extends ScalarSerializer<Enum<?>> {
    EnumValueSerializer() {
        super(new TypeToken<Enum<?>>(){});
    }

    @Override
    public Enum<?> deserialize(Type type2, Object obj) throws SerializationException {
        String enumConstant = obj.toString();
        @Nullable Enum ret2 = EnumLookup.lookupEnum(GenericTypeReflector.erase((Type)type2).asSubclass(Enum.class), enumConstant);
        if (ret2 == null) {
            throw new SerializationException(type2, "Invalid enum constant provided, expected a value of enum, got " + enumConstant);
        }
        return ret2;
    }

    @Override
    public Object serialize(Enum<?> item, Predicate<Class<?>> typeSupported) {
        return item.name();
    }
}

