/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.net.InetAddress;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.cacheddata.CachedMetaData;
import off.szymon.vMessage.Broadcaster;
import off.szymon.vMessage.Config;
import off.szymon.vMessage.VMessagePlugin;
import org.jetbrains.annotations.Nullable;
import space.arim.libertybans.api.ConsoleOperator;
import space.arim.libertybans.api.LibertyBans;
import space.arim.libertybans.api.Operator;
import space.arim.libertybans.api.PlayerOperator;
import space.arim.libertybans.api.PunishmentType;
import space.arim.libertybans.api.punish.Punishment;
import space.arim.libertybans.api.select.SelectionByApplicability;
import space.arim.libertybans.api.select.SelectionByApplicabilityBuilder;

public class Listener {
    @Subscribe
    private void onMessageSend(PlayerChatEvent e) {
        e.setResult(PlayerChatEvent.ChatResult.denied());
        Player player = e.getPlayer();
        Punishment punishment = this.getMute(player.getUniqueId(), player.getRemoteAddress().getAddress());
        if (punishment != null && !punishment.isExpired()) {
            String moderator;
            String reason;
            Broadcaster broadcaster = VMessagePlugin.getInstance().getBroadcaster();
            String msg = Config.getString("messages.chat.muted-message");
            String serverName = player.getCurrentServer().map(server -> broadcaster.parseAlias(server.getServerInfo().getName())).orElse("Unknown");
            String string = reason = punishment.getReason() != null ? punishment.getReason() : "No reason specified";
            String endDate = punishment.isExpired() ? "Expired" : (punishment.getEndDate() != null ? punishment.getEndDate().toString() : "Permanent");
            Operator operator = punishment.getOperator();
            if (operator instanceof PlayerOperator) {
                PlayerOperator playerOp = (PlayerOperator)operator;
                Player p = VMessagePlugin.getInstance().getServer().getPlayer(playerOp.getUUID()).orElse(null);
                moderator = p != null ? p.getUsername() : "Unknown Player";
            } else {
                moderator = operator instanceof ConsoleOperator ? "Console" : "Unknown";
            }
            msg = msg.replace("%player%", player.getUsername()).replace("%message%", e.getMessage()).replace("%server%", serverName).replace("%reason%", reason).replace("%end-date%", endDate).replace("%moderator%", moderator);
            LuckPerms lp = VMessagePlugin.getInstance().getLuckPerms();
            if (lp != null) {
                CachedMetaData data = lp.getPlayerAdapter(Player.class).getMetaData((Object)player);
                msg = msg.replace("%suffix%", Optional.ofNullable(data.getSuffix()).orElse("")).replace("%prefix%", Optional.ofNullable(data.getPrefix()).orElse(""));
                for (Map.Entry<String, String> entry : broadcaster.getMetaPlaceholders().entrySet()) {
                    msg = msg.replace(entry.getKey(), Optional.ofNullable(data.getMetaValue(entry.getValue())).orElse(""));
                }
            }
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)msg));
        } else {
            VMessagePlugin.getInstance().getBroadcaster().message(e.getPlayer(), e.getMessage());
        }
    }

    @Nullable
    private Punishment getMute(UUID playerUuid, InetAddress playerAddress) {
        LibertyBans lb = VMessagePlugin.getInstance().getLibertyBans();
        if (lb == null) {
            return null;
        }
        Optional punishment = (Optional)((SelectionByApplicability)((SelectionByApplicabilityBuilder)lb.getSelector().selectionByApplicabilityBuilder(playerUuid, playerAddress).type(PunishmentType.MUTE)).build()).getFirstSpecificPunishment().toCompletableFuture().join();
        return punishment.orElse(null);
    }

    @Subscribe
    private void onPlayerLeave(DisconnectEvent e) {
        try {
            VMessagePlugin.getInstance().getBroadcaster().leave(e.getPlayer());
        }
        catch (Exception ex) {
            VMessagePlugin.getInstance().getLogger().error("Error while broadcasting player leave event: {}", (Object)ex.getMessage());
        }
    }

    @Subscribe
    private void onPlayerConnect(ServerPostConnectEvent e) {
        RegisteredServer pre = e.getPreviousServer();
        if (pre == null) {
            VMessagePlugin.getInstance().getBroadcaster().join(e.getPlayer());
        } else {
            VMessagePlugin.getInstance().getBroadcaster().change(e.getPlayer(), pre.getServerInfo().getName());
        }
    }
}

