/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage;

import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import off.szymon.vMessage.Config;
import off.szymon.vMessage.VMessagePlugin;

public class VMessageCommand
implements SimpleCommand {
    public void execute(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            invocation.source().sendRichMessage("<#00ffff>vMessage</#00ffff> by <#00ffff>SzymON_OFF</#00ffff>\nVersion: <#00ffff>%s</#00ffff>\n".formatted(VMessagePlugin.getInstance().getPlugin().getDescription().getVersion().get()));
            return;
        }
        switch (args[0].toLowerCase()) {
            case "help": {
                if (!invocation.source().hasPermission("vmessage.command.help")) {
                    invocation.source().sendRichMessage("<red>You don't have permission to use this command.");
                    return;
                }
                invocation.source().sendRichMessage("<#00ffff>vMessage</#00ffff> Help:\n<#00ffff>/vmessage say <player> <message></#00ffff> - Sends a message as a player\n<#00ffff>/vmessage reload</#00ffff> - Reload the config\n<#00ffff>/vmessage help</#00ffff> - Show this help message\n");
                break;
            }
            case "reload": {
                if (invocation.source().hasPermission("vmessage.command.reload")) {
                    Config.reload();
                    VMessagePlugin.getInstance().getBroadcaster().reload();
                    invocation.source().sendRichMessage("<#00ffff>vMessage</#00ffff> config reloaded!");
                    break;
                }
                invocation.source().sendRichMessage("<red>You don't have permission to use this command.");
                break;
            }
            case "say": {
                if (!invocation.source().hasPermission("vmessage.command.say")) {
                    invocation.source().sendRichMessage("<red>You don't have permission to use this command.");
                    return;
                }
                if (args.length < 3) {
                    invocation.source().sendRichMessage("<red>Invalid options:</red> Use <#00ffff>/vmessage help</#00ffff> for more information.");
                    return;
                }
                Player player = VMessagePlugin.getInstance().getServer().getPlayer(args[1]).orElse(null);
                if (player == null) {
                    invocation.source().sendRichMessage("<red>Player not found.");
                    return;
                }
                String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                VMessagePlugin.getInstance().getBroadcaster().message(player, message);
                break;
            }
            default: {
                invocation.source().sendRichMessage("<red>Invalid options:</red> Use <#00ffff>/vmessage help</#00ffff> for more information.");
            }
        }
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("vmessage.command");
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        List<String> options = List.of("help", "reload", "say");
        if (args.length == 1) {
            return CompletableFuture.completedFuture(options.stream().filter(option -> option.toLowerCase().startsWith(args[0].toLowerCase())).sorted().collect(Collectors.toList()));
        }
        if (args.length == 0) {
            return CompletableFuture.completedFuture(options);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("say")) {
            return CompletableFuture.completedFuture(VMessagePlugin.getInstance().getServer().getAllPlayers().stream().map(Player::getUsername).filter(player -> player.toLowerCase().startsWith(args[1].toLowerCase())).sorted().collect(Collectors.toList()));
        }
        return CompletableFuture.completedFuture(List.of());
    }
}

