/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration.implementation.snakeyaml.lib.nodes;

import java.util.List;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.DumperOptions;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.error.Mark;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.nodes.CollectionNode;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.nodes.Node;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.nodes.NodeId;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.nodes.Tag;

public class SequenceNode
extends CollectionNode<Node> {
    private final List<Node> value;

    public SequenceNode(Tag tag, boolean resolved, List<Node> value, Mark startMark, Mark endMark, DumperOptions.FlowStyle flowStyle) {
        super(tag, startMark, endMark, flowStyle);
        if (value == null) {
            throw new NullPointerException("value in a Node is required.");
        }
        this.value = value;
        this.resolved = resolved;
    }

    public SequenceNode(Tag tag, List<Node> value, DumperOptions.FlowStyle flowStyle) {
        this(tag, true, value, null, null, flowStyle);
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.sequence;
    }

    @Override
    public List<Node> getValue() {
        return this.value;
    }

    public void setListType(Class<? extends Object> listType) {
        for (Node node : this.value) {
            node.setType(listType);
        }
    }

    public String toString() {
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", value=" + this.getValue() + ")>";
    }
}

