/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.minimessage.MiniMessage;
import off.szymon.vMessage.Broadcaster;
import off.szymon.vMessage.VMessagePlugin;
import off.szymon.vMessage.compatibility.LuckPermsCompatibilityProvider;
import off.szymon.vMessage.compatibility.mute.MutePluginCompatibilityProvider;
import off.szymon.vMessage.config.ConfigManager;

public class Listener {
    @Subscribe
    private void onMessageSend(PlayerChatEvent e) {
        e.setResult(PlayerChatEvent.ChatResult.denied());
        Player player = e.getPlayer();
        MutePluginCompatibilityProvider mpcp = VMessagePlugin.get().getMutePluginCompatibilityProvider();
        mpcp.isMuted(player).thenAcceptAsync(isMuted -> {
            if (isMuted.booleanValue()) {
                mpcp.getMute(player).thenAcceptAsync(mute -> {
                    Broadcaster broadcaster = VMessagePlugin.get().getBroadcaster();
                    String msg = ConfigManager.get().getConfig().getMessages().getChat().getMutedMessage();
                    String serverName = player.getCurrentServer().map(server -> broadcaster.parseAlias(server.getServerInfo().getName())).orElse("Unknown");
                    String reason = mute.reason();
                    String endDate = mute.endDateString();
                    String moderator = mute.moderator();
                    msg = msg.replace("%player%", player.getUsername()).replace("%message%", e.getMessage()).replace("%server%", serverName).replace("%reason%", reason).replace("%end-date%", endDate).replace("%moderator%", moderator);
                    LuckPermsCompatibilityProvider lp = VMessagePlugin.get().getLuckPermsCompatibilityProvider();
                    if (lp != null) {
                        LuckPermsCompatibilityProvider.PlayerData data2 = lp.getMetaData(player);
                        msg = msg.replace("%suffix%", Optional.ofNullable(data2.metaData().getSuffix()).orElse("")).replace("%prefix%", Optional.ofNullable(data2.metaData().getPrefix()).orElse(""));
                        for (Map.Entry<String, String> entry : broadcaster.getMetaPlaceholders().entrySet()) {
                            msg = msg.replace(entry.getKey(), Optional.ofNullable(data2.metaData().getMetaValue(entry.getValue())).orElse(""));
                        }
                    }
                    player.sendMessage(MiniMessage.miniMessage().deserialize((Object)msg));
                });
            } else {
                VMessagePlugin.get().getBroadcaster().message(e.getPlayer(), e.getMessage());
            }
        });
    }

    @Subscribe
    private void onPlayerLeave(DisconnectEvent e) {
        try {
            VMessagePlugin.get().getBroadcaster().leave(e.getPlayer());
        }
        catch (Exception ex) {
            VMessagePlugin.get().getLogger().error("Error while broadcasting player leave event: {}", (Object)ex.getMessage());
        }
    }

    @Subscribe
    private void onPlayerConnect(ServerPostConnectEvent e) {
        RegisteredServer pre = e.getPreviousServer();
        if (pre == null) {
            VMessagePlugin.get().getBroadcaster().join(e.getPlayer());
        } else {
            VMessagePlugin.get().getBroadcaster().change(e.getPlayer(), pre.getServerInfo().getName());
        }
    }
}

