/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import off.szymon.vMessage.Broadcaster;
import off.szymon.vMessage.Listener;
import off.szymon.vMessage.cmd.CommandRegisterer;
import off.szymon.vMessage.compatibility.LuckPermsCompatibilityProvider;
import off.szymon.vMessage.compatibility.mute.EmptyMuteCompatibilityProvider;
import off.szymon.vMessage.compatibility.mute.LibertyBansCompatibilityProvider;
import off.szymon.vMessage.compatibility.mute.LiteBansCompatibilityProvider;
import off.szymon.vMessage.compatibility.mute.MutePluginCompatibilityProvider;
import off.szymon.vMessage.config.ConfigManager;
import off.szymon.vMessage.libs.bstats.charts.SimplePie;
import off.szymon.vMessage.libs.bstats.velocity.Metrics;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Plugin(id="vmessage", name="vMessage", version="1.8.2", description="The #1 plugin for velocity message syncing", authors={"SzymON_OFF"}, dependencies={@Dependency(id="signedvelocity", optional=true), @Dependency(id="luckperms", optional=true), @Dependency(id="libertybans", optional=true), @Dependency(id="litebans", optional=true)})
public class VMessagePlugin {
    private static VMessagePlugin instance;
    private final ProxyServer server;
    private final Logger logger;
    private final File dataFolder;
    private final PluginContainer plugin;
    private final String name;
    private MutePluginCompatibilityProvider mutePluginCompatibilityProvider;
    private LuckPermsCompatibilityProvider lpCompatibilityProvider;
    private Broadcaster broadcaster;
    private final Metrics.Factory metricsFactory;

    @Inject
    public VMessagePlugin(ProxyServer server, Logger logger, @DataDirectory Path dataFolder, PluginContainer plugin, Metrics.Factory metricsFactory) {
        instance = this;
        this.server = server;
        this.logger = logger;
        this.dataFolder = new File(dataFolder.toFile().getParentFile(), this.getClass().getAnnotation(Plugin.class).name());
        this.plugin = plugin;
        this.metricsFactory = metricsFactory;
        this.name = this.getClass().getAnnotation(Plugin.class).name();
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.onEnable();
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.onDisable();
    }

    public void onEnable() {
        if (!this.server.getPluginManager().isLoaded("signedvelocity")) {
            this.logger.warn("SignedVelocity not detected! vMessage might not work properly without it.");
            this.logger.warn("Please consider installing SignedVelocity on the proxy and backends from https://modrinth.com/plugin/signedvelocity");
            this.logger.warn("Proceeding without it...");
        }
        new ConfigManager();
        if (this.server.getPluginManager().isLoaded("luckperms")) {
            this.logger.info("LuckPerms detected, attempting to hook into it...");
            try {
                this.lpCompatibilityProvider = new LuckPermsCompatibilityProvider();
                this.logger.info("Successfully hooked into LuckPerms");
            }
            catch (Exception e) {
                this.lpCompatibilityProvider = null;
                this.logger.error("Failed to hook into LuckPerms, disabling support");
            }
        } else {
            this.logger.info("LuckPerms not detected, disabling support");
            this.lpCompatibilityProvider = null;
        }
        Map<String, String> mutePlugins = Map.of("libertybans", "LibertyBans", "litebans", "LiteBans");
        this.mutePluginCompatibilityProvider = new EmptyMuteCompatibilityProvider();
        this.logger.info("Checking for mute plugin compatibility...");
        for (Map.Entry<String, String> entry : mutePlugins.entrySet()) {
            String pluginName = entry.getKey();
            String displayName = entry.getValue();
            if (this.server.getPluginManager().isLoaded(pluginName)) {
                this.logger.info("{} detected, attempting to hook into it...", (Object)displayName);
                try {
                    switch (pluginName) {
                        case "libertybans": {
                            this.mutePluginCompatibilityProvider = new LibertyBansCompatibilityProvider();
                            break;
                        }
                        case "litebans": {
                            this.mutePluginCompatibilityProvider = new LiteBansCompatibilityProvider();
                        }
                    }
                    this.logger.info("Successfully hooked into {}", (Object)displayName);
                    break;
                }
                catch (Exception e) {
                    this.mutePluginCompatibilityProvider = new EmptyMuteCompatibilityProvider();
                    this.logger.error("Failed to hook into {}, disabling support", (Object)displayName);
                    continue;
                }
            }
            this.logger.info("{} not detected, disabling support", (Object)displayName);
        }
        this.broadcaster = new Broadcaster();
        this.server.getEventManager().register((Object)this, (Object)new Listener());
        CommandRegisterer.registerCommands();
        Metrics metrics = this.metricsFactory.make(this, 27241);
        metrics.addCustomChart(new SimplePie("mute_plugin", () -> {
            String pluginName = "None";
            if (this.mutePluginCompatibilityProvider instanceof LibertyBansCompatibilityProvider) {
                pluginName = "LibertyBans";
            } else if (this.mutePluginCompatibilityProvider instanceof LiteBansCompatibilityProvider) {
                pluginName = "LiteBans";
            }
            return pluginName;
        }));
    }

    public void onDisable() {
        System.out.println(this.name + " disabled");
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public static VMessagePlugin get() {
        return instance;
    }

    @Nullable(value="If LuckPerms is not loaded, this will return null")
    public @Nullable(value="If LuckPerms is not loaded, this will return null") LuckPermsCompatibilityProvider getLuckPermsCompatibilityProvider() {
        return this.lpCompatibilityProvider;
    }

    public MutePluginCompatibilityProvider getMutePluginCompatibilityProvider() {
        return this.mutePluginCompatibilityProvider;
    }

    public Broadcaster getBroadcaster() {
        return this.broadcaster;
    }

    public PluginContainer getPlugin() {
        return this.plugin;
    }
}

