/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.objectmapping;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import off.szymon.vMessage.libs.configurate.objectmapping.FieldDiscoverer;
import off.szymon.vMessage.libs.configurate.serialize.SerializationException;
import off.szymon.vMessage.libs.configurate.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;

final class RecordFieldDiscoverer
implements FieldDiscoverer<Object[]> {
    static final RecordFieldDiscoverer INSTANCE = new RecordFieldDiscoverer();

    private RecordFieldDiscoverer() {
    }

    @Override
    public <V> @Nullable FieldDiscoverer.InstanceFactory<@Nullable Object[]> discover(AnnotatedType target, FieldDiscoverer.FieldCollector<@Nullable Object[], V> collector2) throws SerializationException {
        Class clazz = GenericTypeReflector.erase((Type)target.getType());
        if (!clazz.isRecord()) {
            return null;
        }
        try {
            RecordComponent[] recordComponents = clazz.getRecordComponents();
            Class[] constructorParams = new Class[recordComponents.length];
            int i2 = 0;
            int recordComponentsLength = recordComponents.length;
            while (i2 < recordComponentsLength) {
                RecordComponent component = recordComponents[i2];
                Method accessor = component.getAccessor();
                accessor.setAccessible(true);
                String name = component.getName();
                AnnotatedType genericType = component.getAnnotatedType();
                constructorParams[i2] = GenericTypeReflector.erase((Type)genericType.getType());
                Field backingField = clazz.getDeclaredField(name);
                backingField.setAccessible(true);
                AnnotatedType resolvedType = GenericTypeReflector.resolveExactType((AnnotatedType)genericType, (AnnotatedType)target);
                AnnotatedElement annotationContainer = Types.combinedAnnotations(component, backingField, accessor);
                int targetIdx = i2++;
                collector2.accept(name, resolvedType, annotationContainer, (intermediate, el, implicitSupplier) -> {
                    intermediate[targetIdx] = el != null ? el : implicitSupplier.get();
                }, x$0 -> accessor.invoke(x$0, new Object[0]));
            }
            Constructor clazzConstructor = clazz.getDeclaredConstructor(constructorParams);
            clazzConstructor.setAccessible(true);
            return new FieldDiscoverer.InstanceFactory<Object[]>(this, recordComponents, constructorParams, clazzConstructor, target){

                @Override
                public Object[] begin() {
                    return new Object[recordComponents.length];
                }

                @Override
                public Object complete(@Nullable Object[] intermediate) throws SerializationException {
                    int length = intermediate.length;
                    for (int i2 = 0; i2 < length; ++i2) {
                        if (intermediate[i2] != null || !constructorParams[i2].isPrimitive()) continue;
                        intermediate[i2] = Types.defaultValue(constructorParams[i2]);
                    }
                    try {
                        return clazzConstructor.newInstance(intermediate);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new SerializationException(target.getType(), (Throwable)e);
                    }
                }

                @Override
                public boolean canCreateInstances() {
                    return true;
                }
            };
        }
        catch (NoSuchFieldException | NoSuchMethodException ex) {
            throw new SerializationException(target.getType(), "Record class did not have fields and accessors aligning specification", (Throwable)ex);
        }
    }
}

