/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.transformation;

import io.leangen.geantyref.TypeToken;
import java.util.function.Supplier;
import off.szymon.vMessage.libs.configurate.ConfigurateException;
import off.szymon.vMessage.libs.configurate.ConfigurationNode;
import off.szymon.vMessage.libs.configurate.NodePath;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface TransformAction {
    public static TransformAction remove() {
        return (path, value) -> {
            value.raw(null);
            return null;
        };
    }

    public static TransformAction rename(Object newKey) {
        return (path, value) -> {
            Object[] arr = path.array();
            if (arr.length == 0) {
                throw new ConfigurateException(value, "The root node cannot be renamed!");
            }
            arr[arr.length - 1] = newKey;
            return arr;
        };
    }

    public static <V> TransformAction set(TypeToken<V> type2, @Nullable V value) {
        return (path, node) -> {
            node.set(type2, value);
            return null;
        };
    }

    public static <V> TransformAction set(TypeToken<V> type2, Supplier<@Nullable V> valueSupplier) {
        return (path, value) -> {
            value.set(type2, valueSupplier.get());
            return null;
        };
    }

    public static <V> TransformAction set(Class<V> type2, Supplier<V> valueSupplier) {
        return (path, value) -> {
            value.set(type2, valueSupplier.get());
            return null;
        };
    }

    public Object @Nullable [] visitPath(NodePath var1, ConfigurationNode var2) throws ConfigurateException;
}

